/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.decryption;

import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.cms.KeyAgreeRecipientIdentifier;
import de.intarsys.asn1.cms.KeyAgreeRecipientInfo;
import de.intarsys.asn1.cms.KeyTransRecipientInfo;
import de.intarsys.asn1.cms.RecipientEncryptedKey;
import de.intarsys.asn1.cms.RecipientEncryptedKeys;
import de.intarsys.asn1.cms.RecipientIdentifier;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.cms.RecipientInfos;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateFilterLiteral;
import de.intarsys.security.certificate.filter.standard.X509CertificateFilterOr;
import de.intarsys.security.certificate.filter.standard.X509CertificateFilterTools;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.collection.NestedIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PKCS7DecryptionTools {
    private static final Logger Log = LoggerFactory.getLogger(PKCS7DecryptionTools.class);

    public static IX509CertificateFilter createCertificateSelector(EnvelopedData envelope) throws IOException {
        IX509CertificateFilter filter = X509CertificateFilterLiteral.REJECT;
        RecipientInfos recipientInfos = envelope.getRecipientInfos();
        for (int i = 0; i < recipientInfos.size(); ++i) {
            RecipientInfo recipientInfo = recipientInfos.get(i);
            IX509CertificateFilter newFilter = PKCS7DecryptionTools.createCertificateSelector(recipientInfo);
            filter = new X509CertificateFilterOr(filter, newFilter);
        }
        return filter;
    }

    public static IX509CertificateFilter createCertificateSelector(RecipientInfo recipientInfo) throws IOException {
        List<IX509CertificateSelector> seletors = PKCS7DecryptionTools.createCertificateSelectors(recipientInfo);
        return X509CertificateFilterTools.or((IX509CertificateFilter[])seletors.toArray(new IX509CertificateFilter[seletors.size()]));
    }

    public static List<IX509CertificateSelector> createCertificateSelectors(RecipientInfo recipientInfo) throws IOException {
        ArrayList<IX509CertificateSelector> selectors = new ArrayList<IX509CertificateSelector>();
        if (recipientInfo.isKeyTransRecipientInfo()) {
            X509CertificateSelector selector = new X509CertificateSelector();
            selector.setSecurityApplication("decryption");
            selector.setHasPrivateKey(Boolean.valueOf(true));
            KeyTransRecipientInfo keyTransRecipientInfo = recipientInfo.getKeyTransRecipientInfo();
            RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
            if (recipientIdentifier.isIssuerAndSerialNumber()) {
                IssuerAndSerialNumber issuerAndSerialNumber = recipientIdentifier.getIssuerAndSerialNumber();
                selector.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
                selector.setIssuer(issuerAndSerialNumber.getIssuer().getDEREncoded());
            } else {
                selector.setSubjectKeyIdentifier(recipientIdentifier.getSubjectKeyIdentifier().getDEREncoded());
            }
            selectors.add((IX509CertificateSelector)selector);
        } else if (recipientInfo.isKeyAgreeRecipientInfo()) {
            KeyAgreeRecipientInfo keyAgreeRecipientInfo = recipientInfo.getKeyAgreeRecipientInfo();
            RecipientEncryptedKeys recipientEncryptedKeys = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
            for (int i = 0; i < recipientEncryptedKeys.size(); ++i) {
                RecipientEncryptedKey recipientEncryptedKey = recipientEncryptedKeys.get(i);
                KeyAgreeRecipientIdentifier recipientIdentifier = recipientEncryptedKey.getRid();
                X509CertificateSelector selector = new X509CertificateSelector();
                selector.setSecurityApplication("decryption");
                selector.setHasPrivateKey(Boolean.valueOf(true));
                if (recipientIdentifier.isIssuerAndSerialNumber()) {
                    IssuerAndSerialNumber issuerAndSerialNumber = recipientIdentifier.getIssuerAndSerialNumber();
                    selector.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
                    selector.setIssuer(issuerAndSerialNumber.getIssuer().getDEREncoded());
                } else {
                    selector.setSubjectKeyIdentifier(recipientIdentifier.getRecipientKeyIdentifier().getSubjectKeyIdentifier().getBytes());
                }
                selectors.add((IX509CertificateSelector)selector);
            }
        } else if (recipientInfo.isKEKRecipientInfo()) {
            Log.warn("KEKRecipientInfo not supported");
        } else if (recipientInfo.isPasswordRecipientInfo()) {
            Log.warn("PasswordRecipientInfo not supported");
        } else if (recipientInfo.isOtherRecipientInfo()) {
            Log.warn("OtherRecipientInfo not supported");
        } else {
            Log.warn("unknown RecipientInfo type");
        }
        return selectors;
    }

    public static Iterator<IX509Certificate> lookupCertificates(EnvelopedData data, ICertificateProvider provider) {
        ArrayList<Iterator> result = new ArrayList<Iterator>();
        RecipientInfos infos = data.getRecipientInfos();
        for (int j = 0; j < infos.size(); ++j) {
            RecipientInfo recipientInfo = infos.get(j);
            try {
                IX509CertificateFilter selector = PKCS7DecryptionTools.createCertificateSelector(recipientInfo);
                Iterator c = provider.lookupCertificates(selector);
                result.add(c);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return new NestedIterator(result.iterator());
    }

    private PKCS7DecryptionTools() {
    }
}

