/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeSignerAttributes;
import de.intarsys.asn1.cms.attr.SignerAttribute;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.asn1.x509.attr.Attributes;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.attribute.X509AttributeFactory;
import de.intarsys.security.certificate.attribute.X509V1AttributeCertificate;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.ISignerAttributesAttribute;
import de.intarsys.security.signature.attribute.impl.SignerAttributesAttribute;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;

public class SignerAttributesDecoder
implements IAttributeDecoder {
    public ISignerAttributesAttribute decodeAttribute(Object srcAttribute) throws IOException {
        Attribute cmsAttribute = (Attribute)srcAttribute;
        AttributeSignerAttributes attrSignerAttributes = (AttributeSignerAttributes)AttributeSignerAttributes.FACTORY.create((ASN1Encodable)cmsAttribute);
        if (attrSignerAttributes == null || attrSignerAttributes.getSignerAttribute() == null) {
            return null;
        }
        SignerAttribute signerAttribute = attrSignerAttributes.getSignerAttribute();
        IX509AttributeCertificate[] attributeCertificates = this.getAttributeCertificates(signerAttribute);
        IX509Attribute[] claimedAttributes = this.getClaimedAttributes(signerAttribute);
        return new SignerAttributesAttribute(attributeCertificates, claimedAttributes);
    }

    private IX509AttributeCertificate[] getAttributeCertificates(SignerAttribute signerAttribute) throws IOException {
        ArrayList<X509V1AttributeCertificate> result = new ArrayList<X509V1AttributeCertificate>();
        for (AttributeCertificate attributeCertificate : signerAttribute.getCertifiedAttributes()) {
            try {
                result.add(new X509V1AttributeCertificate(attributeCertificate));
            }
            catch (CertificateException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        return result.toArray(new IX509AttributeCertificate[result.size()]);
    }

    private IX509Attribute[] getClaimedAttributes(SignerAttribute signerAttribute) throws IOException {
        ArrayList<IX509Attribute> result = new ArrayList<IX509Attribute>();
        for (Attributes attributes : signerAttribute.getClaimedAttributes()) {
            for (Attribute attribute : attributes.getAll()) {
                IX509Attribute x509Attribute = X509AttributeFactory.get().create(attribute);
                result.add(x509Attribute);
            }
        }
        return result.toArray(new IX509Attribute[result.size()]);
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.18";
    }
}

