/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.observation.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import de.intarsys.tools.observation.api.Observer;
import de.intarsys.tools.observation.logback.ObservationAppender;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackObserver
extends Observer {
    private static final Logger Log = LoggerFactory.getLogger(LogbackObserver.class);
    private static final String LOGGER_OBSERVATION = "observation";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private Object appender;

    public static void reset() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
    }

    public Appender<?> createAppender() {
        if (this.appender instanceof Appender) {
            return (Appender)this.appender;
        }
        Object object = this.appender;
        if (object instanceof String) {
            String appenderPath = (String)object;
            String[] segments = appenderPath.split("/");
            String loggerName = "ROOT";
            String appenderName = null;
            if (segments.length == 1) {
                appenderName = segments[0];
            } else {
                loggerName = segments[0];
                appenderName = segments[1];
            }
            Logger logger = LoggerFactory.getLogger((String)loggerName);
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
            Iterator itAppenders = logbackLogger.iteratorForAppenders();
            while (itAppenders.hasNext()) {
                Appender current = (Appender)itAppenders.next();
                if (!current.getName().equals(appenderName)) continue;
                return current;
            }
        }
        throw new IllegalArgumentException("'" + this.appender + "' cannot be converted to Appender");
    }

    protected String createObservationAppenderName() {
        return "observer-" + COUNTER.getAndIncrement();
    }

    @PostConstruct
    public void install() {
        List<String> sourceList = this.getSource();
        if (sourceList == null || sourceList.isEmpty()) {
            this.installAppender(null);
            return;
        }
        for (String source : sourceList) {
            this.installAppender(source);
        }
    }

    private void installAppender(String source) {
        Object name = LOGGER_OBSERVATION;
        if (!StringTools.isEmpty((String)source)) {
            name = (String)name + "." + source;
        }
        Appender<?> tmpAppender = this.createAppender();
        ObservationAppender observationAppender = new ObservationAppender(this.createObservationAppenderName(), this, tmpAppender);
        Context context = (Context)LoggerFactory.getILoggerFactory();
        this.installObject(context, null, observationAppender, new HashSet<Object>());
        Logger logger = LoggerFactory.getLogger((String)name);
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
        logbackLogger.addAppender((Appender)observationAppender);
    }

    protected void installObject(Context context, Object parent, Object value, Set<Object> visited) {
        if (value == null) {
            return;
        }
        if (visited.contains(value)) {
            return;
        }
        visited.add(value);
        HashSet fields = new HashSet();
        HashSet classes = new HashSet();
        for (Class<?> clazz = value.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz.getName().startsWith("java")) continue;
            classes.add(clazz);
            Collections.addAll(classes, clazz.getInterfaces());
            Collections.addAll(fields, clazz.getDeclaredFields());
        }
        Optional<Class> found = classes.stream().filter(candidate -> Collection.class.isAssignableFrom((Class<?>)candidate) || candidate.getName().startsWith("ch.qos.logback")).findAny();
        if (found.isEmpty()) {
            return;
        }
        for (Field field : fields) {
            this.installObjectField(context, value, field, visited);
        }
        if (value instanceof ContextAware) {
            try {
                ((ContextAware)value).setContext(context);
            }
            catch (Exception e) {
                Log.warn("failed to contextualize LogbackObserver component", (Throwable)e);
            }
        }
        if (value instanceof RollingPolicy && parent instanceof FileAppender) {
            try {
                ((RollingPolicy)value).setParent((FileAppender)parent);
            }
            catch (Exception e) {
                Log.warn("failed to set parent in LogbackObserver component", (Throwable)e);
            }
        }
        if (value instanceof LayoutWrappingEncoder && parent instanceof ContextAware) {
            try {
                ((LayoutWrappingEncoder)value).setParent((ContextAware)parent);
            }
            catch (Exception e) {
                Log.warn("failed to set parent in LogbackObserver component", (Throwable)e);
            }
        }
        if (value instanceof LifeCycle) {
            try {
                ((LifeCycle)value).start();
            }
            catch (Exception e) {
                Log.warn("failed to start LogbackObserver component", (Throwable)e);
            }
        }
    }

    protected void installObjectField(Context context, Object parent, Field field, Set<Object> visited) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            field.setAccessible(true);
            Object value = field.get(parent);
            this.installObject(context, parent, value, visited);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAppender(Object appender) {
        this.appender = appender;
    }
}

