/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.observation.impl;

import de.intarsys.tools.observation.impl.CommonStatement;
import de.intarsys.tools.valueholder.INamedValue;
import java.util.List;
import java.util.regex.Pattern;

public abstract class PatternBasedStatement
extends CommonStatement {
    private String pattern;
    private Pattern compiledPattern;

    protected PatternBasedStatement() {
    }

    protected PatternBasedStatement(String pattern) {
        this.setPattern(pattern);
    }

    @Override
    public void execute(List<INamedValue> result, List<INamedValue> values) {
        for (INamedValue namedValue : values) {
            if (!(this.negate() ^ this.matches(namedValue.getName()))) continue;
            this.putNamedValue(result, namedValue);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    protected boolean matches(String name) {
        return this.compiledPattern.matcher(name).matches();
    }

    protected abstract boolean negate();

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.compiledPattern = Pattern.compile(pattern);
    }
}

