/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.form.model.FieldValue;
import de.intarsys.tools.form.model.Form;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;

public class FormValue {
    private Form form;
    private List<FieldValue> values = new ArrayList<FieldValue>();

    public static FormValue createFromArgs(IArgs args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        FormValue result = new FormValue();
        Form form = Form.createFromArgs(ArgTools.getArgs((IArgs)args, (String)"form", null));
        if (form == null) {
            throw new IllegalArgumentException("invalid form value");
        }
        result.setForm(form);
        IArgs argValues = ArgTools.getArgs((IArgs)args, (String)"values", null);
        if (argValues == null) {
            throw new IllegalArgumentException("invalid form value");
        }
        for (IArgs.IBinding binding : argValues) {
            FieldValue value = FieldValue.createFrom(form, binding);
            if (value == null) continue;
            result.addFieldValue(value);
        }
        return result;
    }

    public void addFieldValue(FieldValue value) {
        this.values.add(value);
    }

    public void expandValues(IStringEvaluator templateEvaluator) throws EvaluationException {
        for (FieldValue fieldValue : this.getValues()) {
            fieldValue.expand(templateEvaluator);
        }
    }

    public Form getForm() {
        return this.form;
    }

    public FieldValue getValue(String name) {
        return this.values.stream().filter(value -> value.getField().getId().equals(name)).findAny().orElse(null);
    }

    public List<FieldValue> getValues() {
        return this.values;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public void setValues(List<FieldValue> values) {
        this.values = values;
    }
}

