/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.form.model.FieldType;
import de.intarsys.tools.form.model.FieldTypes;
import de.intarsys.tools.form.model.Form;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.modeling.model.CommonDomain;
import de.intarsys.tools.modeling.model.CommonValue;
import de.intarsys.tools.modeling.model.IDomain;
import de.intarsys.tools.modeling.model.IValue;
import de.intarsys.tools.modeling.model.IVariableResolver;
import de.intarsys.tools.string.StringTools;

public abstract class CommonField {
    private Form form;
    private FieldType type;
    private String id;
    private String label;
    private String description;
    private float x;
    private float y;
    private float width;
    private float height;
    private String pageRange;
    private EnumResize hResize;
    private EnumResize vResize;
    private IDomain domain;
    private boolean editable;
    private boolean required;
    private IValue initialValue;
    private IArgs properties;

    public static CommonField createFromArgs(IArgs args) {
        FieldType type = FieldTypes.getFieldType(args);
        return type.createField(args);
    }

    protected CommonField(FieldType type, IArgs args) {
        this.type = type;
        this.initFromArgs(args);
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        return StringTools.safeString((Object)value);
    }

    public Object getDefaultInitialValue() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public IDomain getDomain() {
        return this.domain;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public Form getForm() {
        return this.form;
    }

    public float getHeight() {
        return this.height;
    }

    public EnumResize getHResize() {
        return this.hResize;
    }

    public String getId() {
        return this.id;
    }

    public IValue getInitialValue() {
        return this.initialValue;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPageRange() {
        return this.pageRange;
    }

    public IArgs getProperties() {
        return this.properties;
    }

    public Object getProperty(String name, Object defaultValue) {
        return ArgTools.getObject((IArgs)this.properties, (String)name, (Object)defaultValue);
    }

    public boolean getRequired() {
        return this.required;
    }

    public FieldType getType() {
        return this.type;
    }

    public EnumResize getVResize() {
        return this.vResize;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    protected void initFromArgs(IArgs args) {
        this.setDescription(ArgTools.getString((IArgs)args, (String)"label", (String)this.getType().getLabel()));
        this.setDomain(CommonDomain.createFrom(ArgTools.getObject((IArgs)args, (String)"domain", null)));
        this.setEditable(ArgTools.getBoolStrict((IArgs)args, (String)"editable", (boolean)true));
        this.setHeight(ArgTools.getFloatStrict((IArgs)args, (String)"height", (float)100.0f));
        this.setId(ArgTools.getString((IArgs)args, (String)"id", null));
        this.setInitialValue(CommonValue.createFrom(ArgTools.getObject((IArgs)args, (String)"initialValue", null)));
        this.setLabel(ArgTools.getString((IArgs)args, (String)"label", (String)this.getType().getLabel()));
        this.setPageRange(ArgTools.getString((IArgs)args, (String)"pageRange", (String)"0"));
        this.setProperties(ArgTools.getArgs((IArgs)args, (String)"properties", (IArgs)Args.create()));
        this.setRequired(ArgTools.getBoolStrict((IArgs)args, (String)"required", (boolean)false));
        this.setHResize((EnumResize)ArgTools.getEnumItemStrict((IArgs)args, (EnumMeta)EnumResize.META, (String)"hResize", (EnumItem)((EnumResize)null)));
        this.setVResize((EnumResize)ArgTools.getEnumItemStrict((IArgs)args, (EnumMeta)EnumResize.META, (String)"vResize", (EnumItem)((EnumResize)null)));
        this.setWidth(ArgTools.getFloatStrict((IArgs)args, (String)"width", (float)100.0f));
        this.setX(ArgTools.getFloatStrict((IArgs)args, (String)"x", (float)0.0f));
        this.setY(ArgTools.getFloatStrict((IArgs)args, (String)"y", (float)0.0f));
    }

    public Object resolveInitialValue(IVariableResolver resolver) {
        return this.initialValue != null ? this.initialValue.resolve(resolver) : this.getDefaultInitialValue();
    }

    public Object restore(Object value) {
        return value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDomain(IDomain domain) {
        this.domain = domain;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setHResize(EnumResize hResize) {
        this.hResize = hResize;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInitialValue(IValue initialValue) {
        this.initialValue = initialValue;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPageRange(String pageRange) {
        this.pageRange = pageRange;
    }

    public void setProperties(IArgs properties) {
        this.properties = properties;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public void setVResize(EnumResize vResize) {
        this.vResize = vResize;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public Object store(Object value) {
        return value;
    }
}

