/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.form.model.FieldType;
import de.intarsys.tools.form.model.TextBasedField;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.BooleanTools;

public class CheckboxField
extends TextBasedField {
    private boolean threeState = false;

    public CheckboxField(FieldType type, IArgs args) {
        super(type, args);
    }

    @Override
    public Object getDefaultInitialValue() {
        return false;
    }

    public boolean isThreeState() {
        return this.threeState;
    }

    @Override
    public Object restore(Object value) {
        if (this.isThreeState() && value == null) {
            return null;
        }
        try {
            return BooleanTools.toBoolean((Object)value, (boolean)false);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("'" + value + "' not a legal boolean field value");
        }
    }

    public void setThreeState(boolean threeState) {
        this.threeState = threeState;
    }
}

