/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.httpcomponents;

import de.intarsys.tools.http.httpcomponents.CredentialCleanupResponseInterceptor;
import de.intarsys.tools.http.httpcomponents.OSDependentConfigurationOutlet;
import java.net.ProxySelector;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public class StandardHttpClientBuilder {
    private Lookup<AuthSchemeProvider> authSchemeRegistry;
    private int connectTimeout = 30000;
    private CredentialsProvider credentialsProvider;
    private HostnameVerifier hostnameVerifier;
    private int socketTimeout = 30000;
    private SSLContext sslContext;

    public StandardHttpClientBuilder() {
        OSDependentConfigurationOutlet.get().configureClientBuilder(this);
    }

    public CloseableHttpClient build() {
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setProxyPreferredAuthSchemes(Arrays.asList("NTLM", "Digest", "Basic")).build();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        return HttpClientBuilder.create().addInterceptorLast((HttpResponseInterceptor)new CredentialCleanupResponseInterceptor()).setDefaultAuthSchemeRegistry(this.authSchemeRegistry).setDefaultCredentialsProvider(this.credentialsProvider).setDefaultRequestConfig(requestConfig).setRoutePlanner((HttpRoutePlanner)routePlanner).setSSLHostnameVerifier(this.hostnameVerifier).setSSLContext(this.sslContext).build();
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public StandardHttpClientBuilder setAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.authSchemeRegistry = authSchemeRegistry;
        return this;
    }

    public StandardHttpClientBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public StandardHttpClientBuilder setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public StandardHttpClientBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public final StandardHttpClientBuilder setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final StandardHttpClientBuilder setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }
}

