/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.http.common.HttpConstants;
import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.http.content.HttpContentTools;
import de.intarsys.tools.http.content.HttpEntityDecoder;
import de.intarsys.tools.http.content.IHttpEntityDecoder;
import de.intarsys.tools.http.locator.FileItemLocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;

public class HttpEntityMultipartFormDataDecoder
extends HttpEntityDecoder {
    private static DiskFileItemFactory Factory;
    private static final IHttpEntityDecoder DEFAULT;

    @Override
    protected Object basicDecode(Header[] headers, final HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        final String contentType = HttpTools.getContentType((Header[])headers);
        final String charset = HttpTools.getContentTypeParamCharset((Header[])headers, (String)HttpConstants.CHARSET_DEFAULT);
        final int length = HttpTools.getContentLengthName((Header[])headers);
        JakartaServletFileUpload upload = new JakartaServletFileUpload(this.getFileItemFactory());
        try {
            List items = upload.parseRequest(new RequestContext(){

                public String getCharacterEncoding() {
                    return charset;
                }

                public long getContentLength() {
                    return length;
                }

                public String getContentType() {
                    return contentType;
                }

                public InputStream getInputStream() throws IOException {
                    return entity.getContent();
                }

                public boolean isMultipartRelated() {
                    return "multipart/related".equals(this.getContentType());
                }
            });
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (FileItem item : items) {
                String fieldName = item.getFieldName();
                Object oldValue = map.get(fieldName);
                Object value = this.unmarshal(item, HttpConstants.CHARSET_DEFAULT);
                if (oldValue instanceof List) {
                    ((List)oldValue).add(value);
                    continue;
                }
                if (oldValue != null) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(oldValue);
                    list.add(value);
                    map.put(fieldName, list);
                    continue;
                }
                map.put(fieldName, value);
            }
            return map;
        }
        catch (FileUploadException e) {
            throw new IOException("upload error", e);
        }
    }

    @Override
    public String getContentType() {
        return "multipart/form-data";
    }

    protected synchronized FileItemFactory getFileItemFactory() {
        if (Factory == null) {
            File tempDir = TempTools.getTempDirVM();
            Factory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setFileCleaningTracker(Tracker).setPath(tempDir.toPath())).get();
        }
        return Factory;
    }

    protected Object unmarshal(FileItem item, String defaultCharset) throws IOException {
        if (item.isFormField()) {
            String contentType = HttpTools.getHeaderElementName((String)item.getContentType(), (String)"text/plain");
            IHttpEntityDecoder decoder = HttpContentTools.selectDecoder(contentType, DEFAULT);
            if (decoder == null) {
                throw new IOException("unsupported content type '" + contentType + "'");
            }
            InputStream is = item.getInputStream();
            int length = (int)item.getSize();
            InputStreamEntity entity = new InputStreamEntity(is, (long)length);
            BasicHeader header = item.getContentType() == null ? new BasicHeader("Content-Type", "text/plain") : new BasicHeader("Content-Type", item.getContentType());
            return decoder.decode(new Header[]{header}, (HttpEntity)entity);
        }
        return new FileItemLocator(item);
    }

    static {
        DEFAULT = HttpEntityDecoder.lookupDecoder("application/octet-stream");
    }
}

