/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.content.HttpEntityEncoder;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class HttpEntityApplicationFormUrlEncodedEncoder
extends HttpEntityEncoder {
    @Override
    protected HttpEntity basicEncode(Object value) throws IOException {
        value = this.wrap(value);
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        this.createEntity(nvps, null, value);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
        return entity;
    }

    protected void createEntity(List<NameValuePair> nvps, String name, Object value) throws IOException {
        if ((value = this.convert(value)) instanceof IArgs) {
            this.createEntityArgs(nvps, name, (IArgs)value);
        } else if (value instanceof Map) {
            this.createEntityMap(nvps, name, (Map)value);
        } else if (value instanceof Object[]) {
            this.createEntityArray(nvps, name, (Object[])value);
        } else if (value instanceof Collection) {
            this.createEntityCollection(nvps, name, (Collection)value);
        } else if (value instanceof Iterator) {
            this.createEntityIterator(nvps, name, (Iterator)value);
        } else {
            nvps.add((NameValuePair)new BasicNameValuePair(name, this.serialize(value)));
        }
    }

    protected void createEntityArgs(List<NameValuePair> nvps, String prefix, IArgs args) throws IOException {
        int i = 0;
        Iterator it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)it.next();
            Object name = binding.getName();
            if (name == null) {
                name = "" + i;
            }
            ++i;
            Object value = binding.getValue();
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(nvps, tempName, value);
        }
    }

    protected void createEntityArray(List<NameValuePair> nvps, String prefix, Object[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            String name = String.valueOf(i);
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            Object value = array[i];
            this.createEntity(nvps, tempName, value);
        }
    }

    protected void createEntityCollection(List<NameValuePair> nvps, String prefix, Collection collection) throws IOException {
        int i = 0;
        for (Object value : collection) {
            String name = String.valueOf(i);
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(nvps, tempName, value);
            ++i;
        }
    }

    protected void createEntityIterator(List<NameValuePair> nvps, String prefix, Iterator it) throws IOException {
        int i = 0;
        while (it.hasNext()) {
            Object value = it.next();
            String name = String.valueOf(i);
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(nvps, tempName, value);
            ++i;
        }
    }

    protected void createEntityMap(List<NameValuePair> nvps, String prefix, Map map) throws IOException {
        for (Map.Entry entry : map.entrySet()) {
            String name = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(nvps, tempName, value);
        }
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    protected String serialize(Object value) throws IOException {
        if (value == null) {
            return "";
        }
        try {
            return (String)ConverterRegistry.get().convert(value, String.class);
        }
        catch (ConversionException e) {
            throw new IOException(e);
        }
    }
}

