/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.authenticate;

import de.intarsys.aaa.authenticate.api.CredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.ICredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredentialScope;
import de.intarsys.aaa.authenticate.api.ICredentialStore;
import de.intarsys.aaa.authenticate.impl.BasicCredentialProvider;
import de.intarsys.aaa.authenticate.impl.NTCredential;
import de.intarsys.aaa.authenticate.impl.UserPasswordCredential;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.http.authenticate.HttpCredentialScope;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;

public class CredentialProviderBasedAuthenticator
extends Authenticator {
    private BasicCredentialProvider requested = new BasicCredentialProvider();

    public CredentialProviderBasedAuthenticator() {
        Authenticator.setDefault(this);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String host;
        try {
            host = InetAddress.getByName(this.getRequestingHost()).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            host = this.getRequestingHost();
        }
        String scheme = this.getRequestingScheme() == null ? null : this.getRequestingScheme().toUpperCase();
        HttpCredentialScope scope = new HttpCredentialScope(host, this.getRequestingPort(), this.getRequestingPrompt(), scheme);
        ICredential credential = this.requested.getCredential((ICredentialScope)scope);
        ICredentialProvider provider = CredentialProvider.get();
        if (credential != null && provider instanceof ICredentialStore) {
            ((ICredentialStore)provider).removeCredential((ICredentialScope)scope);
        }
        credential = provider.getCredential((ICredentialScope)scope);
        this.requested.setCredential((ICredentialScope)scope, credential);
        if (!(credential instanceof UserPasswordCredential)) {
            return null;
        }
        UserPasswordCredential userPwCredential = (UserPasswordCredential)credential;
        Object user = userPwCredential.getUser();
        if (userPwCredential instanceof NTCredential && !"NTLM".equalsIgnoreCase(this.getRequestingScheme())) {
            user = ((NTCredential)userPwCredential).getDomain() + "/" + (String)user;
        }
        Secret password = userPwCredential.getPassword();
        PasswordAuthentication pa = new PasswordAuthentication((String)user, CryptoTools.getCharsNotNull((Secret)password, (char[])new char[0]));
        return pa;
    }
}

