/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs.logging;

import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import de.intarsys.tools.jaxrs.logging.LoggingInterceptor;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.jersey.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
@Priority(value=-2147483648)
final class ServerLoggingFilter
extends LoggingInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    public ServerLoggingFilter(Logger logger, Level level, LoggingFeature.Verbosity verbosity, int maxEntitySize) {
        super(logger, level, verbosity, maxEntitySize);
    }

    public void filter(ContainerRequestContext context) throws IOException {
        if (!this.logger.isEnabledForLevel(this.level)) {
            return;
        }
        long tmpId = this.id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)tmpId);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", tmpId, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, tmpId, "> ", (MultivaluedMap<String, String>)context.getHeaders());
        if (context.hasEntity() && ServerLoggingFilter.printEntity(this.verbosity, context.getMediaType())) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), MessageUtils.getCharset((MediaType)context.getMediaType())));
        }
        this.log(b);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.logger.isEnabledForLevel(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long tmpId = requestId != null ? ((Long)requestId).longValue() : this.id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", tmpId, responseContext.getStatus());
        this.printPrefixedHeaders(b, tmpId, "< ", (MultivaluedMap<String, String>)responseContext.getStringHeaders());
        if (responseContext.hasEntity() && ServerLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType())) {
            LoggingInterceptor.LoggingStream stream = new LoggingInterceptor.LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }
}

