/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.conversation.impl;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.component.IReferenceCounter;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.CancelStage;
import de.intarsys.tools.conversation.impl.ErrorStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.impl.ResultStage;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.string.StringTools;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversation<R>
implements IConversation<R>,
IDisposable,
IReferenceCounter {
    private static final Logger Log = LoggerFactory.getLogger(Conversation.class);
    private AtomicInteger active = new AtomicInteger();
    private final String handle;
    private final Object lock = new Object();
    private final String name;
    private final AtomicReference<SharedState> sharedState = new AtomicReference();
    private final AtomicReference<Conversation<?>> inner = new AtomicReference();
    private AtomicBoolean forwardTermination = new AtomicBoolean(false);
    private CompletableFuture<R> completionStage;

    public static <T> IConversation<T> cancelled() {
        Conversation conversation = new Conversation("cancelled");
        conversation.cancel(true);
        return conversation;
    }

    public static <T> IConversation<T> completed(T result) {
        Conversation<T> conversation = new Conversation<T>("completed");
        conversation.complete(result);
        return conversation;
    }

    protected static String createConversationHandle() {
        return UUID.randomUUID().toString();
    }

    public static <T> IConversation<T> failed(Throwable e) {
        Conversation conversation = new Conversation("failed");
        conversation.completeExceptionally(e);
        return conversation;
    }

    public static boolean isCancellation(Throwable t) {
        return ExceptionTools.isCancellation((Throwable)t);
    }

    @Deprecated
    public static <T> IConversation<T> processed(T result) {
        return Conversation.completed(result);
    }

    public static RuntimeException rethrowable(Throwable ex) {
        if (ex instanceof RuntimeException) {
            RuntimeException rex = (RuntimeException)ex;
            return rex;
        }
        return new CompletionException(ExceptionTools.unwrap((Throwable)ex));
    }

    public Conversation(String name) {
        this(name, new SharedState(), null);
        this.completionStage = new CompletableFuture();
    }

    protected Conversation(String name, SharedState sharedState, Conversation inner) {
        this.name = name;
        this.handle = Conversation.createConversationHandle();
        this.sharedState.set(sharedState);
        this.inner.set(inner);
        Log.trace("conversation created {}", (Object)this);
    }

    @Override
    public void acknowledge(String inReplyTo, Object value) {
        IReplyStage currentStage = this.basicGetReplyStage();
        this.submit(() -> this.basicAcknowledge(currentStage, inReplyTo, value));
    }

    public Object acquire() {
        Log.debug("{} acquire", (Object)this);
        this.getState().ref.incrementAndGet();
        return null;
    }

    protected void basicAcknowledge(IReplyStage currentStage, String inReplyTo, Object value) {
        if (currentStage.getId().equals(inReplyTo)) {
            Log.trace("conversation {} acknowledge inReplyTo {}", (Object)this, (Object)inReplyTo);
            currentStage.acknowledge(value);
        } else if (inReplyTo == null) {
            Log.trace("conversation {} acknowledge missing inReplyTo, using current", (Object)this);
            currentStage.acknowledge(value);
        } else {
            Log.trace("conversation {} acknowledge skip, inReplyTo {} outdated ({})", new Object[]{this, inReplyTo, currentStage.getId()});
        }
    }

    protected IReplyStage basicGetReplyStage() {
        if (this.isDone()) {
            try {
                return new ResultStage(this.completionStage.get());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return new CancelStage();
            }
            catch (Exception ex) {
                Throwable cause = ExceptionTools.unwrap((Throwable)ex);
                if (ExceptionTools.isCancellation((Throwable)ex)) {
                    return new CancelStage();
                }
                return new ErrorStage(cause);
            }
        }
        IReplyStage result = this.getState().replyStage.get();
        return result == null || this.active.get() > 0 ? this.createDefaultReplyStage() : result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completionStage.cancel(mayInterruptIfRunning);
    }

    @Override
    public void complete(R result) {
        this.completionStage.complete(result);
    }

    @Override
    public void completeExceptionally(Throwable ex) {
        this.completionStage.completeExceptionally(ex);
    }

    protected IReplyStage createDefaultReplyStage() {
        return new ProcessingStage();
    }

    public final void dispose() {
        Object[] keys;
        Log.debug("{} dispose", (Object)this);
        AttributeMap tempAttributes = this.getState().attributes;
        for (Object key : keys = tempAttributes.getKeys()) {
            Object value = tempAttributes.getAttribute(key);
            if (!this.isSimpleObject(value)) {
                tempAttributes.removeAttribute(key);
            }
            if (value instanceof IConversation || !(value instanceof IDisposable)) continue;
            IDisposable disposable = (IDisposable)value;
            Log.debug("{} disposing {}", (Object)this, (Object)StringTools.safeString((Object)value));
            disposable.dispose();
        }
    }

    @Override
    public IConversation<R> exceptionally(Throwing.Function<Throwable, ? extends R> function) {
        Conversation<R> c = new Conversation<R>(Format.simple((String)"exceptionally({})", (Object[])new Object[]{this.getName()}), this.sharedState.get(), this);
        CompletionStage tmpFuture = this.completionStage.exceptionally((T ex) -> {
            try {
                return function.apply(ex);
            }
            catch (Throwable t) {
                throw Conversation.rethrowable(t);
            }
        });
        c.completionStage = tmpFuture;
        return c;
    }

    @Override
    public IConversation<R> exceptionallyCompose(Throwing.Function<Throwable, IConversation<R>> recover) {
        Conversation c = new Conversation(Format.simple((String)"exceptionallyCompose({})", (Object[])new Object[]{this.getName()}), this.sharedState.get(), this);
        CompletionStage tmpFuture = ((CompletableFuture)this.completionStage.handle((result, ex) -> {
            if (ex == null) {
                return CompletableFuture.completedFuture(result);
            }
            try {
                Conversation newInner = (Conversation)recover.apply(ex);
                c.setInner(newInner);
                return newInner.getCompletionStage();
            }
            catch (Throwable t) {
                throw Conversation.rethrowable(t);
            }
        })).thenCompose((T x) -> x);
        c.completionStage = tmpFuture;
        return c;
    }

    @Override
    public void forwardTermination() {
        if (this.forwardTermination.compareAndSet(false, true)) {
            this.forwardTerminationBasic(this.inner.get());
        }
    }

    protected void forwardTerminationBasic(Conversation<?> innverValue) {
        if (innverValue != null) {
            this.whenComplete((r, ex) -> innverValue.cancel(false));
            innverValue.forwardTermination();
        }
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        return this.completionStage.get();
    }

    public Object getAttribute(Object key) {
        return this.getState().attributes.getAttribute(key);
    }

    protected CompletableFuture<R> getCompletionStage() {
        return this.completionStage;
    }

    public ExecutorService getExecutor() {
        return this.getState().executor.get();
    }

    @Override
    public String getHandle() {
        return this.handle;
    }

    public String getName() {
        return this.name;
    }

    public int getReferenceCount() {
        return this.getState().ref.get();
    }

    @Override
    public IReplyStage getReplyStage() {
        return this.basicGetReplyStage();
    }

    protected SharedState getState() {
        return this.sharedState.get();
    }

    @Override
    public boolean isCancelled() {
        return this.completionStage.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.completionStage.isCompletedExceptionally();
    }

    @Override
    public boolean isDone() {
        return this.completionStage.isDone();
    }

    protected boolean isSimpleObject(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number;
    }

    @Override
    public <E extends Exception> void monitor(final Throwing.Specific.Supplier<IConversation<R>, E> task) {
        this.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Conversation.this.isDone()) {
                        return;
                    }
                    IConversation newInner = (IConversation)task.get();
                    Conversation.this.setInner((Conversation)newInner);
                    newInner.exceptionally(ex -> {
                        Conversation.this.completeExceptionally(ExceptionTools.unwrap((Throwable)ex));
                        return null;
                    });
                    newInner.thenAccept(r -> Conversation.this.complete(r));
                }
                catch (Throwable e) {
                    Conversation.this.completeExceptionally(ExceptionTools.unwrap((Throwable)e));
                }
            }
        });
    }

    public boolean release(Object handle) {
        Log.debug("{} release", (Object)this);
        int ref = this.getState().ref.decrementAndGet();
        if (ref == 0) {
            this.dispose();
            return true;
        }
        return false;
    }

    public Object removeAttribute(Object key) {
        return this.getState().attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.getState().attributes.setAttribute(key, value);
    }

    @Override
    public void setExecutor(ExecutorService executor) {
        this.getState().executor.set(executor);
    }

    protected void setInner(Conversation newValue) {
        this.inner.set(newValue);
        newValue.switchState(this.sharedState.get());
        if (this.forwardTermination.get()) {
            this.forwardTerminationBasic(newValue);
        }
    }

    @Override
    public void setReplyStage(IReplyStage replyStage) {
        if (replyStage != null && replyStage.isFinal()) {
            throw new IllegalArgumentException("use complete, completeExceptionally or cancel for final stages");
        }
        this.getState().replyStage.set(replyStage);
        Log.trace("{} reply stage changed to {}", (Object)this, (Object)replyStage);
    }

    protected void submit(Runnable runnable) {
        ExecutorService tmpExecutor = this.getExecutor();
        this.active.incrementAndGet();
        Runnable submitted = () -> {
            try {
                runnable.run();
            }
            finally {
                this.active.decrementAndGet();
            }
        };
        if (tmpExecutor == null) {
            submitted.run();
        } else {
            tmpExecutor.submit(submitted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchState(SharedState outerState) {
        Object object = this.lock;
        synchronized (object) {
            Conversation<?> innverValue = this.inner.get();
            if (innverValue != null) {
                innverValue.switchState(outerState);
            } else {
                this.sharedState.get().mergeInto(outerState);
            }
            this.sharedState.set(outerState);
        }
    }

    @Override
    public <E extends Exception> IConversation<Void> thenAccept(Throwing.Specific.Consumer<R, E> consumer) {
        Conversation<Void> c = new Conversation<Void>(Format.simple((String)"thenAccept({})", (Object[])new Object[]{this.getName()}), this.sharedState.get(), this);
        CompletionStage tmpFuture = this.completionStage.thenAccept((T result) -> {
            try {
                consumer.accept(result);
            }
            catch (Exception e) {
                throw Conversation.rethrowable(e);
            }
        });
        c.completionStage = tmpFuture;
        return c;
    }

    @Override
    public <U, E extends Exception> IConversation<U> thenApply(Throwing.Specific.Function<? super R, ? extends U, E> function) {
        Conversation<R> c = new Conversation<R>(Format.simple((String)"thenApply({})", (Object[])new Object[]{this.getName()}), this.sharedState.get(), this);
        CompletionStage tmpFuture = this.completionStage.thenApply((T result) -> {
            try {
                return function.apply(result);
            }
            catch (Exception e) {
                throw Conversation.rethrowable(e);
            }
        });
        c.completionStage = tmpFuture;
        return c;
    }

    @Override
    public <U, E extends Exception> IConversation<U> thenCompose(Throwing.Specific.Function<? super R, ? extends IConversation<U>, E> function) {
        String newName = Format.simple((String)"thenCompose({})", (Object[])new Object[]{this.getName()});
        Conversation c = new Conversation(newName, this.sharedState.get(), this);
        CompletionStage tmpFuture = this.completionStage.thenCompose((T result) -> {
            try {
                Conversation newInner = (Conversation)function.apply(result);
                c.setInner(newInner);
                return newInner.getCompletionStage();
            }
            catch (Exception e) {
                throw Conversation.rethrowable(e);
            }
        });
        c.completionStage = tmpFuture;
        return c;
    }

    public String toString() {
        return this.getName() + "(" + this.getHandle() + ")";
    }

    @Override
    public <E extends Exception> IConversation<R> whenComplete(Throwing.Specific.BiConsumer<? super R, ? super Throwable, E> function) {
        Conversation<R> c = new Conversation<R>(Format.simple((String)"whenComplete({})", (Object[])new Object[]{this.getName()}), this.sharedState.get(), this);
        CompletionStage tmpFuture = this.completionStage.whenComplete((T result, U ex) -> {
            try {
                function.accept(result, ex);
            }
            catch (Exception e) {
                throw Conversation.rethrowable(e);
            }
        });
        c.completionStage = tmpFuture;
        return c;
    }

    static class SharedState {
        protected final AttributeMap attributes = new AttributeMap();
        protected final AtomicReference<ExecutorService> executor = new AtomicReference();
        protected final AtomicReference<IReplyStage> replyStage = new AtomicReference();
        protected final AtomicInteger ref = new AtomicInteger(0);

        SharedState() {
        }

        public void mergeInto(SharedState parentState) {
            parentState.attributes.putAll(this.attributes);
            parentState.replyStage.set(this.replyStage.get());
            parentState.ref.addAndGet(this.ref.get());
        }
    }
}

