/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.unit;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.internal.MathUtil;
import tec.uom.lib.common.function.SymbolSupplier;
import tec.uom.lib.common.function.UnitConverterSupplier;

public enum MetricPrefix implements SymbolSupplier,
UnitConverterSupplier
{
    YOTTA("Y", RationalConverter.of(1.0E24, 1.0)),
    ZETTA("Z", RationalConverter.of(1.0E21, 1.0)),
    EXA("E", RationalConverter.of(MathUtil.pow(10.0, 18.0), 1.0)),
    PETA("P", RationalConverter.of(MathUtil.pow(10.0, 15.0), 1.0)),
    TERA("T", RationalConverter.of(MathUtil.pow(10.0, 12.0), 1.0)),
    GIGA("G", RationalConverter.of(MathUtil.pow(10.0, 9.0), 1.0)),
    MEGA("M", RationalConverter.of(MathUtil.pow(10.0, 6.0), 1.0)),
    KILO("k", RationalConverter.of(MathUtil.pow(10.0, 3.0), 1.0)),
    HECTO("h", RationalConverter.of(100.0, 1.0)),
    DEKA("da", RationalConverter.of(10.0, 1.0)),
    DECI("d", RationalConverter.of(1.0, 10.0)),
    CENTI("c", RationalConverter.of(1.0, 100.0)),
    MILLI("m", RationalConverter.of(1.0, 1000.0)),
    MICRO("\u00b5", RationalConverter.of(1.0, MathUtil.pow(10.0, 6.0))),
    NANO("n", RationalConverter.of(1.0, MathUtil.pow(10.0, 9.0))),
    PICO("p", RationalConverter.of(1.0, MathUtil.pow(10.0, 12.0))),
    FEMTO("f", RationalConverter.of(1.0, MathUtil.pow(10.0, 15.0))),
    ATTO("a", RationalConverter.of(1.0, MathUtil.pow(10.0, 18.0))),
    ZEPTO("z", RationalConverter.of(1.0, MathUtil.pow(10.0, 21.0))),
    YOCTO("y", RationalConverter.of(1.0, MathUtil.pow(10.0, 24.0)));

    private final String symbol;
    private final UnitConverter converter;

    private MetricPrefix(String symbol, RationalConverter converter) {
        this.symbol = symbol;
        this.converter = converter;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public UnitConverter getConverter() {
        return this.converter;
    }

    public static final <Q extends Quantity<Q>> Unit<Q> YOTTA(Unit<Q> unit) {
        return unit.transform(YOTTA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> ZETTA(Unit<Q> unit) {
        return unit.transform(ZETTA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> EXA(Unit<Q> unit) {
        return unit.transform(EXA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> PETA(Unit<Q> unit) {
        return unit.transform(PETA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> TERA(Unit<Q> unit) {
        return unit.transform(TERA.getConverter());
    }

    public static <Q extends Quantity<Q>> Unit<Q> GIGA(Unit<Q> unit) {
        return unit.transform(GIGA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> MEGA(Unit<Q> unit) {
        return unit.transform(MEGA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> KILO(Unit<Q> unit) {
        return unit.transform(KILO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> HECTO(Unit<Q> unit) {
        return unit.transform(HECTO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> DEKA(Unit<Q> unit) {
        return unit.transform(DEKA.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> DECI(Unit<Q> unit) {
        return unit.transform(DECI.getConverter());
    }

    public static <Q extends Quantity<Q>> Unit<Q> CENTI(Unit<Q> unit) {
        return unit.transform(CENTI.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> MILLI(Unit<Q> unit) {
        return unit.transform(MILLI.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> MICRO(Unit<Q> unit) {
        return unit.transform(MICRO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> NANO(Unit<Q> unit) {
        return unit.transform(NANO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> PICO(Unit<Q> unit) {
        return unit.transform(PICO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> FEMTO(Unit<Q> unit) {
        return unit.transform(FEMTO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> ATTO(Unit<Q> unit) {
        return unit.transform(ATTO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> ZEPTO(Unit<Q> unit) {
        return unit.transform(ZEPTO.getConverter());
    }

    public static final <Q extends Quantity<Q>> Unit<Q> YOCTO(Unit<Q> unit) {
        return unit.transform(YOCTO.getConverter());
    }
}

