/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.quantity.NumberQuantity;

final class FloatQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    final float value;

    public FloatQuantity(float value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert((double)this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    public Quantity<Q> add(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().floatValue(), this.getUnit());
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().floatValue(), this.getUnit());
    }

    public Quantity<?> multiply(Quantity<?> that) {
        return new FloatQuantity<Q>(this.value * that.getValue().floatValue(), this.getUnit().multiply(that.getUnit()));
    }

    public Quantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.floatValue(), this.getUnit().multiply(that.doubleValue()));
    }

    public Quantity<?> divide(Quantity<?> that) {
        return new FloatQuantity<Q>(this.value / that.getValue().floatValue(), this.getUnit().divide(that.getUnit()));
    }

    public Quantity<Q> inverse() {
        return NumberQuantity.of(1.0f / this.value, this.getUnit().inverse());
    }

    public Quantity<Q> divide(Number that) {
        return NumberQuantity.of(this.value / that.floatValue(), this.getUnit());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(Float.valueOf(this.value), that.getValue());
        }
        return false;
    }
}

