/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.internal.format.l10n;

import java.util.Vector;
import tec.units.ri.internal.format.l10n.AttributedCharacterFieldDelegate;
import tec.units.ri.internal.format.l10n.AttributedCharacterIterator;
import tec.units.ri.internal.format.l10n.DecimalFormatSymbols;
import tec.units.ri.internal.format.l10n.DigitList;
import tec.units.ri.internal.format.l10n.FieldPosition;
import tec.units.ri.internal.format.l10n.Format;
import tec.units.ri.internal.format.l10n.NumberFormat;

class DecimalFormat
extends NumberFormat {
    private String mPattern = "#,##0.###";
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private transient FieldPosition[] positivePrefixFieldPositions;
    private transient FieldPosition[] positiveSuffixFieldPositions;
    private transient FieldPosition[] negativePrefixFieldPositions;
    private transient FieldPosition[] negativeSuffixFieldPositions;
    private byte minExponentDigits;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static FieldPosition[] EmptyFieldPositionArray = new FieldPosition[0];
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;

    DecimalFormat() {
        this.symbols = new DecimalFormatSymbols();
        this.applyPattern(this.mPattern, false);
    }

    DecimalFormat(String pattern) {
        this.symbols = new DecimalFormatSymbols();
        this.applyPattern(pattern, false);
    }

    DecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        this.symbols = symbols.clone();
        this.applyPattern(pattern, false);
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(number, result, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double number, StringBuffer result, Format.FieldDelegate delegate) {
        boolean isNegative;
        if (Double.isNaN(number)) {
            int iFieldStart = result.length();
            result.append(this.symbols.getNaN());
            delegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, iFieldStart, result.length(), result);
            return result;
        }
        boolean bl = isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        if (isNegative) {
            number = -number;
        }
        if (this.multiplier != 1) {
            number *= (double)this.multiplier;
        }
        if (Double.isInfinite(number)) {
            if (isNegative) {
                this.append(result, this.negativePrefix, delegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(result, this.positivePrefix, delegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
            }
            int iFieldStart = result.length();
            result.append(this.symbols.getInfinity());
            delegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, iFieldStart, result.length(), result);
            if (isNegative) {
                this.append(result, this.negativeSuffix, delegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(result, this.positiveSuffix, delegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
            }
            return result;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            return this.subformat(result, delegate, isNegative, false);
        }
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(number, result, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long number, StringBuffer result, Format.FieldDelegate delegate) {
        boolean isNegative;
        boolean bl = isNegative = number < 0L;
        if (isNegative) {
            number = -number;
        }
        if (this.multiplier != 1 && this.multiplier != 0) {
            long cutoff;
            boolean useDouble = false;
            if (number < 0L) {
                cutoff = Long.MIN_VALUE / (long)this.multiplier;
                useDouble = number < cutoff;
            } else {
                cutoff = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl2 = useDouble = number > cutoff;
            }
            if (useDouble) {
                double dnumber = isNegative ? -number : number;
                return this.format(dnumber, result, delegate);
            }
        }
        number *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            return this.subformat(result, delegate, isNegative, true);
        }
    }

    @Override
    AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        AttributedCharacterFieldDelegate delegate = new AttributedCharacterFieldDelegate();
        StringBuffer sb = new StringBuffer();
        if (obj instanceof Long) {
            this.format((long)((Long)obj), sb, (Format.FieldDelegate)delegate);
        } else {
            if (obj == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            if (obj instanceof Double) {
                this.format((double)((Double)obj), sb, (Format.FieldDelegate)delegate);
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Number");
            }
        }
        return delegate.getIterator(sb.toString());
    }

    private StringBuffer subformat(StringBuffer result, Format.FieldDelegate delegate, boolean isNegative, boolean isInteger) {
        char decimal;
        char zero = this.symbols.getZeroDigit();
        int zeroDelta = zero - 48;
        char grouping = this.symbols.getGroupingSeparator();
        char c = decimal = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        int fieldStart = result.length();
        if (isNegative) {
            this.append(result, this.negativePrefix, delegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(result, this.positivePrefix, delegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
        }
        if (this.useExponentialNotation) {
            int i;
            boolean negativeExponent;
            int totalDigits;
            int integerDigits;
            int iFieldStart = result.length();
            int iFieldEnd = -1;
            int fFieldStart = -1;
            int exponent = this.digitList.decimalAt;
            int repeat = this.getMaximumIntegerDigits();
            int minimumIntegerDigits = this.getMinimumIntegerDigits();
            if (repeat > 1 && repeat > minimumIntegerDigits) {
                exponent = exponent >= 1 ? (exponent - 1) / repeat * repeat : (exponent - repeat) / repeat * repeat;
                minimumIntegerDigits = 1;
            } else {
                exponent -= minimumIntegerDigits;
            }
            int minimumDigits = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
            int n = integerDigits = this.digitList.isZero() ? minimumIntegerDigits : this.digitList.decimalAt - exponent;
            if (minimumDigits < integerDigits) {
                minimumDigits = integerDigits;
            }
            if (minimumDigits > (totalDigits = this.digitList.count)) {
                totalDigits = minimumDigits;
            }
            boolean addedDecimalSeparator = false;
            for (int i2 = 0; i2 < totalDigits; ++i2) {
                if (i2 == integerDigits) {
                    iFieldEnd = result.length();
                    result.append(decimal);
                    addedDecimalSeparator = true;
                    fFieldStart = result.length();
                }
                result.append(i2 < this.digitList.count ? (char)(this.digitList.digits[i2] + zeroDelta) : zero);
            }
            if (iFieldEnd == -1) {
                iFieldEnd = result.length();
            }
            delegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, iFieldStart, iFieldEnd, result);
            if (addedDecimalSeparator) {
                delegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, iFieldEnd, fFieldStart, result);
            }
            if (fFieldStart == -1) {
                fFieldStart = result.length();
            }
            delegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, fFieldStart, result.length(), result);
            fieldStart = result.length();
            result.append(this.symbols.getExponentialSymbol());
            delegate.formatted(NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SYMBOL, fieldStart, result.length(), result);
            if (this.digitList.isZero()) {
                exponent = 0;
            }
            boolean bl = negativeExponent = exponent < 0;
            if (negativeExponent) {
                exponent = -exponent;
                this.append(result, this.negativePrefix, delegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            } else {
                this.append(result, this.positivePrefix, delegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            }
            this.digitList.set(exponent);
            int eFieldStart = result.length();
            for (i = this.digitList.decimalAt; i < this.minExponentDigits; ++i) {
                result.append(zero);
            }
            for (i = 0; i < this.digitList.decimalAt; ++i) {
                result.append(i < this.digitList.count ? (char)(this.digitList.digits[i] + zeroDelta) : zero);
            }
            delegate.formatted(NumberFormat.Field.EXPONENT, NumberFormat.Field.EXPONENT, eFieldStart, result.length(), result);
            fieldStart = result.length();
            if (negativeExponent) {
                this.append(result, this.negativeSuffix, delegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            } else {
                this.append(result, this.positiveSuffix, delegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            }
        } else {
            boolean fractionPresent;
            int iFieldStart = result.length();
            int count = this.getMinimumIntegerDigits();
            int digitIndex = 0;
            if (this.digitList.decimalAt > 0 && count < this.digitList.decimalAt) {
                count = this.digitList.decimalAt;
            }
            if (count > this.getMaximumIntegerDigits()) {
                count = this.getMaximumIntegerDigits();
                digitIndex = this.digitList.decimalAt - count;
            }
            int sizeBeforeIntegerPart = result.length();
            for (int i = count - 1; i >= 0; --i) {
                if (i < this.digitList.decimalAt && digitIndex < this.digitList.count) {
                    result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
                } else {
                    result.append(zero);
                }
                if (!this.isGroupingUsed() || i <= 0 || this.groupingSize == 0 || i % this.groupingSize != 0) continue;
                int gStart = result.length();
                result.append(grouping);
                delegate.formatted(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, gStart, result.length(), result);
            }
            boolean bl = fractionPresent = this.getMinimumFractionDigits() > 0 || !isInteger && digitIndex < this.digitList.count;
            if (!fractionPresent && result.length() == sizeBeforeIntegerPart) {
                result.append(zero);
            }
            delegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, iFieldStart, result.length(), result);
            int sStart = result.length();
            if (this.decimalSeparatorAlwaysShown || fractionPresent) {
                result.append(decimal);
            }
            if (sStart != result.length()) {
                delegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, sStart, result.length(), result);
            }
            int fFieldStart = result.length();
            for (int i = 0; i < this.getMaximumFractionDigits() && (i < this.getMinimumFractionDigits() || !isInteger && digitIndex < this.digitList.count); ++i) {
                if (-1 - i > this.digitList.decimalAt - 1) {
                    result.append(zero);
                    continue;
                }
                if (!isInteger && digitIndex < this.digitList.count) {
                    result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
                    continue;
                }
                result.append(zero);
            }
            delegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, fFieldStart, result.length(), result);
        }
        if (isNegative) {
            this.append(result, this.negativeSuffix, delegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(result, this.positiveSuffix, delegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
        }
        return result;
    }

    private void append(StringBuffer result, String string, Format.FieldDelegate delegate, FieldPosition[] positions, Format.Field signAttribute) {
        int start = result.length();
        if (string.length() > 0) {
            result.append(string);
            for (FieldPosition fp : positions) {
                Format.Field attribute = fp.getFieldAttribute();
                if (attribute == NumberFormat.Field.SIGN) {
                    attribute = signAttribute;
                }
                delegate.formatted(attribute, attribute, start + fp.getBeginIndex(), start + fp.getEndIndex(), result);
            }
        }
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return this.symbols.clone();
        }
        catch (Exception foo) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        try {
            this.symbols = newSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String newValue) {
        this.positivePrefix = newValue;
        this.posPrefixPattern = null;
        this.positivePrefixFieldPositions = null;
    }

    private FieldPosition[] getPositivePrefixFieldPositions() {
        if (this.positivePrefixFieldPositions == null) {
            this.positivePrefixFieldPositions = this.posPrefixPattern != null ? this.expandAffix(this.posPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.positivePrefixFieldPositions;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String newValue) {
        this.negativePrefix = newValue;
        this.negPrefixPattern = null;
    }

    private FieldPosition[] getNegativePrefixFieldPositions() {
        if (this.negativePrefixFieldPositions == null) {
            this.negativePrefixFieldPositions = this.negPrefixPattern != null ? this.expandAffix(this.negPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.negativePrefixFieldPositions;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String newValue) {
        this.positiveSuffix = newValue;
        this.posSuffixPattern = null;
    }

    private FieldPosition[] getPositiveSuffixFieldPositions() {
        if (this.positiveSuffixFieldPositions == null) {
            this.positiveSuffixFieldPositions = this.posSuffixPattern != null ? this.expandAffix(this.posSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.positiveSuffixFieldPositions;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String newValue) {
        this.negativeSuffix = newValue;
        this.negSuffixPattern = null;
    }

    private FieldPosition[] getNegativeSuffixFieldPositions() {
        if (this.negativeSuffixFieldPositions == null) {
            this.negativeSuffixFieldPositions = this.negSuffixPattern != null ? this.expandAffix(this.negSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.negativeSuffixFieldPositions;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int newValue) {
        this.multiplier = newValue;
    }

    int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int newValue) {
        this.groupingSize = (byte)newValue;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.decimalSeparatorAlwaysShown = newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DecimalFormat other = (DecimalFormat)obj;
        return (this.posPrefixPattern == other.posPrefixPattern && this.positivePrefix.equals(other.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(other.posPrefixPattern)) && (this.posSuffixPattern == other.posSuffixPattern && this.positiveSuffix.equals(other.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(other.posSuffixPattern)) && (this.negPrefixPattern == other.negPrefixPattern && this.negativePrefix.equals(other.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(other.negPrefixPattern)) && (this.negSuffixPattern == other.negSuffixPattern && this.negativeSuffix.equals(other.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(other.negSuffixPattern)) && this.multiplier == other.multiplier && this.groupingSize == other.groupingSize && this.decimalSeparatorAlwaysShown == other.decimalSeparatorAlwaysShown && this.useExponentialNotation == other.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == other.minExponentDigits) && this.symbols.equals(other.symbols);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer buffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, buffer);
            this.positivePrefixFieldPositions = null;
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, buffer);
            this.positiveSuffixFieldPositions = null;
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, buffer);
            this.negativePrefixFieldPositions = null;
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, buffer);
            this.negativeSuffixFieldPositions = null;
        }
    }

    private String expandAffix(String pattern, StringBuffer buffer) {
        buffer.setLength(0);
        int i = 0;
        block6: while (i < pattern.length()) {
            char c;
            if ((c = pattern.charAt(i++)) == '\'') {
                c = pattern.charAt(i++);
                switch (c) {
                    case '\u00a4': {
                        buffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                    }
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private FieldPosition[] expandAffix(String pattern) {
        Vector<FieldPosition> positions = null;
        int stringIndex = 0;
        int i = 0;
        block6: while (i < pattern.length()) {
            char c;
            if ((c = pattern.charAt(i++)) == '\'') {
                int field = -1;
                NumberFormat.Field fieldID = null;
                c = pattern.charAt(i++);
                switch (c) {
                    case '\u00a4': {
                        String string = this.symbols.getCurrencySymbol();
                        if (string.length() <= 0) continue block6;
                        if (positions == null) {
                            positions = new Vector(2);
                        }
                        FieldPosition fp = new FieldPosition(NumberFormat.Field.CURRENCY);
                        fp.setBeginIndex(stringIndex);
                        fp.setEndIndex(stringIndex + string.length());
                        positions.addElement(fp);
                        stringIndex += string.length();
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        field = -1;
                        fieldID = NumberFormat.Field.PERCENT;
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        field = -1;
                        fieldID = NumberFormat.Field.PERMILLE;
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                        field = -1;
                        fieldID = NumberFormat.Field.SIGN;
                    }
                }
                if (fieldID != null) {
                    if (positions == null) {
                        positions = new Vector<FieldPosition>(2);
                    }
                    FieldPosition fp = new FieldPosition(fieldID, field);
                    fp.setBeginIndex(stringIndex);
                    fp.setEndIndex(stringIndex + 1);
                    positions.addElement(fp);
                }
            }
            ++stringIndex;
        }
        if (positions != null) {
            EmptyFieldPositionArray = new FieldPosition[positions.size()];
            positions.copyInto(EmptyFieldPositionArray);
        }
        return EmptyFieldPositionArray;
    }

    private void appendAffix(StringBuffer buffer, String affixPattern, String expAffix, boolean localized) {
        if (affixPattern == null) {
            this.appendAffix(buffer, expAffix, localized);
        } else {
            int pos = 0;
            while (pos < affixPattern.length()) {
                int i = affixPattern.indexOf(39, pos);
                if (i < 0) {
                    this.appendAffix(buffer, affixPattern.substring(pos), localized);
                    break;
                }
                if (i > pos) {
                    this.appendAffix(buffer, affixPattern.substring(pos, i), localized);
                }
                char c = affixPattern.charAt(++i);
                ++i;
                if (c == '\'') {
                    buffer.append(c);
                } else if (c == '\u00a4' && i < affixPattern.length() && affixPattern.charAt(i) == '\u00a4') {
                    buffer.append(c);
                } else if (localized) {
                    switch (c) {
                        case '%': {
                            c = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c = this.symbols.getMinusSign();
                        }
                    }
                }
                buffer.append(c);
                pos = ++i;
            }
        }
    }

    private void appendAffix(StringBuffer buffer, String affix, boolean localized) {
        boolean needQuote;
        if (localized) {
            needQuote = affix.indexOf(this.symbols.getZeroDigit()) >= 0 || affix.indexOf(this.symbols.getGroupingSeparator()) >= 0 || affix.indexOf(this.symbols.getDecimalSeparator()) >= 0 || affix.indexOf(this.symbols.getPercent()) >= 0 || affix.indexOf(this.symbols.getPerMill()) >= 0 || affix.indexOf(this.symbols.getDigit()) >= 0 || affix.indexOf(this.symbols.getPatternSeparator()) >= 0 || affix.indexOf(this.symbols.getMinusSign()) >= 0 || affix.indexOf(164) >= 0;
        } else {
            boolean bl = needQuote = affix.indexOf(48) >= 0 || affix.indexOf(44) >= 0 || affix.indexOf(46) >= 0 || affix.indexOf(37) >= 0 || affix.indexOf(8240) >= 0 || affix.indexOf(35) >= 0 || affix.indexOf(59) >= 0 || affix.indexOf(45) >= 0 || affix.indexOf(164) >= 0;
        }
        if (needQuote) {
            buffer.append('\'');
        }
        if (affix.indexOf(39) < 0) {
            buffer.append(affix);
        } else {
            for (int j = 0; j < affix.length(); ++j) {
                char c = affix.charAt(j);
                buffer.append(c);
                if (c != '\'') continue;
                buffer.append(c);
            }
        }
        if (needQuote) {
            buffer.append('\'');
        }
    }

    private String toPattern(boolean localized) {
        StringBuffer result = new StringBuffer();
        for (int j = 1; j >= 0; --j) {
            int digitCount;
            int i;
            if (j == 1) {
                this.appendAffix(result, this.posPrefixPattern, this.positivePrefix, localized);
            } else {
                this.appendAffix(result, this.negPrefixPattern, this.negativePrefix, localized);
            }
            for (i = digitCount = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1; i > 0; --i) {
                if (i != digitCount && this.isGroupingUsed() && this.groupingSize != 0 && i % this.groupingSize == 0) {
                    result.append(localized ? this.symbols.getGroupingSeparator() : (char)',');
                }
                result.append(i <= this.getMinimumIntegerDigits() ? (localized ? this.symbols.getZeroDigit() : (char)'0') : (localized ? this.symbols.getDigit() : (char)'#'));
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                result.append(localized ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            for (i = 0; i < this.getMaximumFractionDigits(); ++i) {
                if (i < this.getMinimumFractionDigits()) {
                    result.append(localized ? this.symbols.getZeroDigit() : (char)'0');
                    continue;
                }
                result.append(localized ? this.symbols.getDigit() : (char)'#');
            }
            if (this.useExponentialNotation) {
                result.append(localized ? this.symbols.getExponentialSymbol() : (char)'E');
                for (i = 0; i < this.minExponentDigits; ++i) {
                    result.append(localized ? this.symbols.getZeroDigit() : (char)'0');
                }
            }
            if (j == 1) {
                this.appendAffix(result, this.posSuffixPattern, this.positiveSuffix, localized);
                if ((this.negSuffixPattern == this.posSuffixPattern && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || this.negPrefixPattern == this.posPrefixPattern && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                result.append(localized ? this.symbols.getPatternSeparator() : (char)';');
                continue;
            }
            this.appendAffix(result, this.negSuffixPattern, this.negativeSuffix, localized);
        }
        return result.toString();
    }

    public void applyPattern(String pattern) {
        this.applyPattern(pattern, false);
    }

    void applyLocalizedPattern(String pattern) {
        this.applyPattern(pattern, true);
    }

    private void applyPattern(String pattern, boolean localized) {
        char zeroDigit = '0';
        char groupingSeparator = ',';
        char decimalSeparator = '.';
        char percent = '%';
        char perMill = '\u2030';
        char digit = '#';
        char separator = ';';
        char exponent = 'E';
        char minus = '-';
        if (localized) {
            zeroDigit = this.symbols.getZeroDigit();
            groupingSeparator = this.symbols.getGroupingSeparator();
            decimalSeparator = this.symbols.getDecimalSeparator();
            percent = this.symbols.getPercent();
            perMill = this.symbols.getPerMill();
            digit = this.symbols.getDigit();
            separator = this.symbols.getPatternSeparator();
            exponent = this.symbols.getExponentialSymbol();
            minus = this.symbols.getMinusSign();
        }
        boolean gotNegative = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int phaseOneStart = 0;
        int phaseOneLength = 0;
        int start = 0;
        for (int j = 1; j >= 0 && start < pattern.length(); --j) {
            boolean inQuote = false;
            StringBuffer prefix = new StringBuffer();
            StringBuffer suffix = new StringBuffer();
            int decimalPos = -1;
            int multiplier = 1;
            int digitLeftCount = 0;
            int zeroDigitCount = 0;
            int digitRightCount = 0;
            int groupingCount = -1;
            int phase = 0;
            StringBuffer affix = prefix;
            block5: for (int pos = start; pos < pattern.length(); ++pos) {
                char ch = pattern.charAt(pos);
                switch (phase) {
                    case 0: 
                    case 2: {
                        if (inQuote) {
                            if (ch == '\'') {
                                if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                                    ++pos;
                                    affix.append("''");
                                    continue block5;
                                }
                                inQuote = false;
                                continue block5;
                            }
                        } else {
                            if (ch == digit || ch == zeroDigit || ch == groupingSeparator || ch == decimalSeparator) {
                                phase = 1;
                                if (j == 1) {
                                    phaseOneStart = pos;
                                }
                                --pos;
                                continue block5;
                            }
                            if (ch == '\u00a4') {
                                boolean doubled;
                                boolean bl = doubled = pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\u00a4';
                                if (doubled) {
                                    ++pos;
                                }
                                this.isCurrencyFormat = true;
                                affix.append(doubled ? "'\u00a4\u00a4" : "'\u00a4");
                                continue block5;
                            }
                            if (ch == '\'') {
                                if (ch == '\'') {
                                    if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                                        ++pos;
                                        affix.append("''");
                                        continue block5;
                                    }
                                    inQuote = true;
                                    continue block5;
                                }
                            } else {
                                if (ch == separator) {
                                    if (phase == 0 || j == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + ch + "' in pattern \"" + pattern + '\"');
                                    }
                                    start = pos + 1;
                                    pos = pattern.length();
                                    continue block5;
                                }
                                if (ch == percent) {
                                    if (multiplier != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + pattern + '\"');
                                    }
                                    multiplier = 100;
                                    affix.append("'%");
                                    continue block5;
                                }
                                if (ch == perMill) {
                                    if (multiplier != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + pattern + '\"');
                                    }
                                    multiplier = 1000;
                                    affix.append("'\u2030");
                                    continue block5;
                                }
                                if (ch == minus) {
                                    affix.append("'-");
                                    continue block5;
                                }
                            }
                        }
                        affix.append(ch);
                        continue block5;
                    }
                    case 1: {
                        if (j == 1) {
                            ++phaseOneLength;
                        } else {
                            if (--phaseOneLength != 0) continue block5;
                            phase = 2;
                            affix = suffix;
                            continue block5;
                        }
                        if (ch == digit) {
                            if (zeroDigitCount > 0) {
                                ++digitRightCount;
                            } else {
                                ++digitLeftCount;
                            }
                            if (groupingCount < 0 || decimalPos >= 0) continue block5;
                            groupingCount = (byte)(groupingCount + 1);
                            continue block5;
                        }
                        if (ch == zeroDigit) {
                            if (digitRightCount > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + pattern + '\"');
                            }
                            ++zeroDigitCount;
                            if (groupingCount < 0 || decimalPos >= 0) continue block5;
                            groupingCount = (byte)(groupingCount + 1);
                            continue block5;
                        }
                        if (ch == groupingSeparator) {
                            groupingCount = 0;
                            continue block5;
                        }
                        if (ch == decimalSeparator) {
                            if (decimalPos >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + pattern + '\"');
                            }
                            decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
                            continue block5;
                        }
                        if (ch == exponent) {
                            if (this.useExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + pattern + '\"');
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = 0;
                            while (++pos < pattern.length() && pattern.charAt(pos) == zeroDigit) {
                                this.minExponentDigits = (byte)(this.minExponentDigits + 1);
                                ++phaseOneLength;
                            }
                            if (digitLeftCount + zeroDigitCount < 1 || this.minExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + pattern + '\"');
                            }
                            phase = 2;
                            affix = suffix;
                            --pos;
                            continue block5;
                        }
                        phase = 2;
                        affix = suffix;
                        --pos;
                        --phaseOneLength;
                        continue block5;
                    }
                }
            }
            if (zeroDigitCount == 0 && digitLeftCount > 0 && decimalPos >= 0) {
                int n = decimalPos;
                if (n == 0) {
                    ++n;
                }
                digitRightCount = digitLeftCount - n;
                digitLeftCount = n - 1;
                zeroDigitCount = 1;
            }
            if (decimalPos < 0 && digitRightCount > 0 || decimalPos >= 0 && (decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount == 0 || inQuote) {
                throw new IllegalArgumentException("Malformed pattern \"" + pattern + '\"');
            }
            if (j == 1) {
                this.posPrefixPattern = prefix.toString();
                this.posSuffixPattern = suffix.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                int digitTotalCount = digitLeftCount + zeroDigitCount + digitRightCount;
                int effectiveDecimalPos = decimalPos >= 0 ? decimalPos : digitTotalCount;
                this.setMinimumIntegerDigits(effectiveDecimalPos - digitLeftCount);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? digitLeftCount + this.getMinimumIntegerDigits() : 309);
                this.setMaximumFractionDigits(decimalPos >= 0 ? digitTotalCount - decimalPos : 0);
                this.setMinimumFractionDigits(decimalPos >= 0 ? digitLeftCount + zeroDigitCount - decimalPos : 0);
                this.setGroupingUsed(groupingCount > 0);
                this.groupingSize = (byte)(groupingCount > 0 ? groupingCount : 0);
                this.multiplier = multiplier;
                this.setDecimalSeparatorAlwaysShown(decimalPos == 0 || decimalPos == digitTotalCount);
                continue;
            }
            this.negPrefixPattern = prefix.toString();
            this.negSuffixPattern = suffix.toString();
            gotNegative = true;
        }
        if (pattern.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!gotNegative || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        super.setMaximumIntegerDigits(Math.min(newValue, 309));
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        super.setMinimumIntegerDigits(Math.min(newValue, 309));
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        super.setMaximumFractionDigits(Math.min(newValue, 340));
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        super.setMinimumFractionDigits(Math.min(newValue, 340));
    }
}

