/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui.toolkit;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.ui.toolkit.CommonToolkit;
import java.awt.Toolkit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentToolkit
extends CommonToolkit {
    private static final Logger Log = LoggerFactory.getLogger(SilentToolkit.class);
    private Thread workerThread;
    private final ExecutorService executorServiceWorker = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SilentToolkit.this.workerThread = new Thread(r, "headless worker");
            SilentToolkit.this.workerThread.setDaemon(true);
            SilentToolkit.this.workerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    Log.warn("uncaught exception in " + t, e);
                }
            });
            SilentToolkit.this.workerThread.setPriority(5);
            return SilentToolkit.this.workerThread;
        }
    });

    @Override
    public void beep() {
        try {
            for (int i = 0; i < 4; ++i) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected ExecutorService getExecutorServiceWorker() {
        return this.executorServiceWorker;
    }

    @Override
    protected String getToolkitID() {
        return "silent";
    }

    @Override
    public void invokeInUI(Runnable runnable) {
        this.invokeNow(runnable);
    }

    @Override
    public void invokeLater(Runnable runnable) {
        this.getExecutorServiceWorker().submit(runnable);
    }

    @Override
    public void invokeNow(Runnable runnable) {
        if (Thread.currentThread() == this.workerThread) {
            runnable.run();
            return;
        }
        Future<?> result = null;
        result = this.getExecutorServiceWorker().submit(runnable);
        ExceptionTools.futureSimpleGet(result);
    }

    @Override
    public void invokeUpdate(Runnable runnable) {
        this.invokeNow(runnable);
    }

    @Override
    public boolean isSilent() {
        return true;
    }
}

