/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui;

import de.intarsys.tools.event.Event;
import de.intarsys.tools.ui.IUIComponent;
import de.intarsys.tools.ui.UIComponent;
import de.intarsys.tools.ui.UIContainer;
import java.util.List;

public abstract class UIWizard<M, C, T>
extends UIContainer<M, C, T> {
    private UIComponent<M, C, T> currentPage;

    protected UIWizard(IUIComponent parent) {
        super(parent);
        this.initPages();
    }

    protected void activatePage(UIComponent<M, C, T> page) {
        if (page == this.currentPage) {
            return;
        }
        if (this.currentPage != null) {
            this.removePage(this.currentPage);
        }
        this.currentPage = page;
        this.currentPage.createComponent(this.getComponent());
    }

    public UIComponent<M, C, T> getCurrentPage() {
        return this.currentPage;
    }

    protected void initPages() {
    }

    public boolean isNextEnabled() {
        return this.selectNextPage() != this.currentPage;
    }

    public boolean isPreviousEnabled() {
        return this.selectPreviousPage() != this.currentPage;
    }

    protected boolean isVisible(UIComponent<M, C, T> page) {
        return true;
    }

    public void onNextPressed() {
        this.activatePage(this.selectNextPage());
    }

    public void onPreviousPressed() {
        this.activatePage(this.selectPreviousPage());
    }

    protected void removePage(UIComponent<M, C, T> currentPage2) {
    }

    protected UIComponent<M, C, T> selectInitialPage() {
        return this.selectNextPage(-1);
    }

    protected UIComponent<M, C, T> selectNextPage() {
        int index = this.getComponents().indexOf(this.currentPage);
        return this.selectNextPage(index);
    }

    protected UIComponent<M, C, T> selectNextPage(int index) {
        UIComponent<M, C, T> newPage = this.currentPage;
        ++index;
        List temp = this.getComponents();
        while (index < temp.size()) {
            UIComponent tempPage = temp.get(index);
            if (this.isVisible(tempPage)) {
                return tempPage;
            }
            ++index;
        }
        return newPage;
    }

    protected UIComponent<M, C, T> selectPreviousPage() {
        int index = this.getComponents().indexOf(this.currentPage);
        return this.selectPreviousPage(index);
    }

    protected UIComponent<M, C, T> selectPreviousPage(int index) {
        UIComponent<M, C, T> newPage = this.currentPage;
        --index;
        List temp = this.getComponents();
        while (index >= 0) {
            UIComponent tempPage = temp.get(index);
            if (this.isVisible(tempPage)) {
                return tempPage;
            }
            --index;
        }
        return newPage;
    }

    protected void setCurrentPage(UIComponent<M, C, T> currentPage) {
        this.currentPage = currentPage;
    }

    @Override
    protected void updateView(Event e) {
        super.updateView(e);
        if (this.currentPage == null) {
            UIComponent<M, C, T> nextPage = this.selectInitialPage();
            this.activatePage(nextPage);
        }
    }
}

