/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tree;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.tree.CommonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class CommonNodeFactory<N extends CommonNode> {
    private Map<Class<?>, CommonNodeFactory<?>> children;
    private final Map<Object, CommonNode> nodeMap = new WeakHashMap<Object, CommonNode>();
    private final Attribute attrNodeMap = new Attribute("nodeMap");

    protected CommonNodeFactory() {
    }

    public abstract N createNode(CommonNode var1, Object var2);

    public synchronized CommonNodeFactory<?> lookupFactory(Object object) {
        if (this.children == null) {
            return this;
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            CommonNodeFactory<?> factory = this.children.get(clazz);
            if (factory == null) continue;
            return factory;
        }
        return this;
    }

    public synchronized CommonNode lookupNode(CommonNode parent, Object object) {
        if (parent == null) {
            return this.nodeMap.get(object);
        }
        Map tempNodeMap = (Map)parent.getAttribute(this.attrNodeMap);
        if (tempNodeMap == null) {
            return null;
        }
        return (CommonNode)tempNodeMap.get(object);
    }

    public synchronized void registerFactory(Class<?> clazz, CommonNodeFactory<?> factory) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(clazz, factory);
    }

    public synchronized void registerNode(CommonNode parent, CommonNode node) {
        if (parent == null) {
            this.nodeMap.put(node.getObject(), node);
        } else {
            WeakHashMap tempNodeMap = (WeakHashMap)parent.getAttribute(this.attrNodeMap);
            if (tempNodeMap == null) {
                tempNodeMap = new WeakHashMap();
                parent.setAttribute(this.attrNodeMap, tempNodeMap);
            }
            tempNodeMap.put(node.getObject(), node);
        }
    }
}

