/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;

public abstract class TlvElement {
    protected final int identifier;
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    protected TlvElement(int identifier, byte[] buffer) {
        this(identifier, buffer, 0, buffer.length);
    }

    protected TlvElement(int identifier, byte[] buffer, int offset, int length) {
        assert (buffer != null);
        assert (buffer.length >= offset + length);
        this.identifier = identifier;
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public abstract TlvInputStream createTlvInputStream(byte[] var1, int var2, int var3);

    public abstract byte[] getEncoded();

    public int getIdentifier() {
        return this.identifier;
    }

    public int getLength() {
        return this.length;
    }

    public TlvTemplate getTemplate() throws TlvFormatException {
        return new TlvTemplate(this.createTlvInputStream(this.buffer, this.offset, this.length));
    }

    public byte[] getValue() {
        byte[] value = new byte[this.length];
        System.arraycopy(this.buffer, this.offset, value, 0, this.length);
        return value;
    }

    public byte getValueAt(int index) {
        return this.buffer[this.offset + index];
    }

    public abstract boolean isComposite();

    public String toString() {
        return "0x" + Integer.toHexString(this.getIdentifier()) + ":" + HexTools.bytesToHexString(this.buffer, this.offset, this.length, true);
    }
}

