/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.IPrettyPrinterPrimitive;
import de.intarsys.tools.string.StringTools;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class PrettyPrinter {
    private static final String NEWLINE = "\n";
    private static IPrettyPrinterPrimitive PrimitivePrinter = new IPrettyPrinterPrimitive(){

        @Override
        public boolean toString(PrettyPrinter printer, Object value) {
            return PrettyPrinter.toStringPrimitive(printer, value);
        }
    };
    private final StringBuilder sb;
    private final Stack<Context> stack = new Stack();
    private int level;

    public static boolean toStringPrimitive(PrettyPrinter printer, Object value) {
        if (value instanceof String) {
            printer.appendString((String)value);
        } else if (value instanceof Integer) {
            printer.appendString("" + value);
            printer.appendString(", ");
            printer.appendString("0x");
            printer.appendString(Integer.toHexString((Integer)value));
        } else if (value == null) {
            printer.appendString("null");
        } else if (value instanceof byte[]) {
            printer.appendString(HexTools.bytesToHexString((byte[])value));
        } else if (value instanceof IPrettyPrintable) {
            ((IPrettyPrintable)value).toString(printer);
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                printer.appendMember(String.valueOf(entry.getKey()), entry.getValue(), null);
            }
        } else if (value instanceof Collection) {
            int index = 0;
            for (Object element : (Collection)value) {
                printer.appendMember("[" + index++ + "]", element, null);
            }
        } else if (value instanceof Object[]) {
            int index = 0;
            for (Object element : (Object[])value) {
                printer.appendMember("[" + index++ + "]", element, null);
            }
        } else {
            printer.appendString(value.getClass().getName());
            printer.appendString(" ");
            printer.appendString(StringTools.safeString(value));
        }
        return true;
    }

    public PrettyPrinter() {
        this(new StringBuilder(), 0);
    }

    public PrettyPrinter(PrettyPrinter parent) {
        this(parent.getSb(), parent.getLevel());
    }

    public PrettyPrinter(StringBuilder sb, int level) {
        this.sb = sb;
        this.level = level;
    }

    protected void appendIndent() {
        for (int i = 0; i < this.level; ++i) {
            this.sb.append("   ");
        }
    }

    public void appendMember(String name, Object value, String valueLabel) {
        if (!this.stack.isEmpty()) {
            Context context = this.stack.peek();
            this.open(context);
        }
        this.appendIndent();
        this.sb.append(name);
        this.sb.append(" = ");
        if (valueLabel != null) {
            this.sb.append("<");
            this.sb.append(valueLabel);
            this.sb.append("> ");
        }
        this.appendValue(value);
        this.sb.append(NEWLINE);
    }

    public void appendMembers(String name, List list) {
        if (!this.stack.isEmpty()) {
            Context context = this.stack.peek();
            this.open(context);
        }
        this.appendIndent();
        this.sb.append(name);
        this.sb.append(" = ");
        this.appendValue(list);
        this.sb.append(NEWLINE);
    }

    public void appendString(String value) {
        this.sb.append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendValue(Object value) {
        Context context = this.openLazy(value);
        try {
            ListIterator li = this.stack.listIterator(this.stack.size());
            boolean printed = false;
            while (li.hasPrevious()) {
                IPrettyPrinterPrimitive primitive = ((Context)li.previous()).primitive;
                if (primitive == null || !primitive.toString(this, value)) continue;
                printed = true;
                break;
            }
            if (!printed) {
                PrimitivePrinter.toString(this, value);
            }
        }
        catch (Exception e) {
            this.sb.append("<error>");
        }
        finally {
            this.close(context);
        }
    }

    public void close() {
        this.close(this.stack.peek());
    }

    protected void close(Context context) {
        if (context.open) {
            context.open = false;
            --this.level;
            this.appendIndent();
            this.sb.append("}");
        }
        this.stack.pop();
    }

    protected int getLevel() {
        return this.level;
    }

    protected StringBuilder getSb() {
        return this.sb;
    }

    protected void open(Context context) {
        if (context.open) {
            return;
        }
        context.open = true;
        this.sb.append("{");
        this.sb.append(NEWLINE);
        ++this.level;
    }

    public void open(Object value) {
        Context context = this.openLazy(value);
        this.open(context);
    }

    public Context openLazy(Object value) {
        Context context = new Context(value);
        this.stack.push(context);
        return context;
    }

    public final String toString() {
        return this.getSb().toString();
    }

    public final String toString(Object value) {
        this.appendValue(value);
        return this.sb.toString();
    }

    protected static class Context {
        protected IPrettyPrinterPrimitive primitive;
        protected Object object;
        protected boolean open;

        public Context(Object object) {
            this.object = object;
            if (object instanceof IPrettyPrinterPrimitive) {
                this.primitive = (IPrettyPrinterPrimitive)object;
            }
        }
    }
}

