/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.state;

import de.intarsys.tools.state.CommonState;
import de.intarsys.tools.state.ComplexState;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.state.IStateHolder;

public class AtomicState
extends CommonState {
    public static final AtomicState NONE = AtomicState.createInitial("none");
    public static final AtomicState DISPOSED = AtomicState.createFinal("disposed");
    public static final AtomicState NEW = AtomicState.createInitial("new");
    public static final AtomicState ACTIVE = AtomicState.createInitial("active");
    public static final AtomicState OK = AtomicState.createFinal("ok");
    public static final AtomicState CANCELLED = AtomicState.createFinal("cancelled");
    public static final AtomicState FAILED = AtomicState.createFinal("failed");
    protected static final byte T_INITIAL = 0;
    protected static final byte T_OTHER = 1;
    protected static final byte T_FINAL = -1;
    private final String id;
    private final byte type;

    public static AtomicState create(String id) {
        AtomicState.checkID(id);
        return new AtomicState(id, 1);
    }

    public static AtomicState createFinal(String id) {
        AtomicState.checkID(id);
        return new AtomicState(id, -1);
    }

    public static AtomicState createInitial(String id) {
        AtomicState.checkID(id);
        return new AtomicState(id, 0);
    }

    protected AtomicState(String id, byte type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public IState attach(IStateHolder stateHolder) {
        return ComplexState.create(this, null).attach(stateHolder);
    }

    @Override
    public void enterState(IState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected String getPrefix() {
        return "(a)";
    }

    @Override
    public IState getRootState() {
        return this;
    }

    @Override
    public IState getState() {
        return null;
    }

    @Override
    public boolean isAncestorOf(IState state) {
        return this == state.getRootState();
    }

    @Override
    public boolean isFinal() {
        return this.type == -1;
    }

    @Override
    public boolean isInitial() {
        return this.type == 0;
    }
}

