/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.session;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.component.ExpirationPredicate;
import de.intarsys.tools.component.ExpireTimeout;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.oid.IOIDGenerator;
import de.intarsys.tools.oid.UUIDGenerator;
import de.intarsys.tools.session.ISession;
import de.intarsys.tools.string.StringTools;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSession
implements ISession {
    private static final int DEFAULT_EXPIRE_AFTER = 300000;
    private static final Logger Log = LoggerFactory.getLogger(StandardSession.class);
    private static IOIDGenerator<String> OidGenerator = new UUIDGenerator();
    private final AttributeMap attributes = new AttributeMap();
    private final EventDispatcher dispatcher = new EventDispatcher(this);
    private final String id;
    private final long startTime;
    private ExpirationPredicate expiration;
    private final Object lock = new Object();
    private boolean disposed;
    private final String label;

    protected static String createSessionId() {
        return OidGenerator.createOID();
    }

    public static IOIDGenerator<String> getOidGenerator() {
        return OidGenerator;
    }

    public static void setOidGenerator(IOIDGenerator<String> oidGenerator) {
        OidGenerator = oidGenerator;
    }

    public StandardSession() {
        this(StandardSession.createSessionId());
    }

    public StandardSession(String id) {
        this.id = id;
        this.label = "session " + id;
        this.startTime = System.currentTimeMillis();
        this.setExpiration(this.getDefaultExpiration());
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected void basicDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        Object[] keys;
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        Log.debug("{} dispose", this.getLabel());
        for (Object key : keys = this.attributes.getKeys()) {
            Object value = this.attributes.get(key);
            if (!(value instanceof IDisposable)) continue;
            Log.debug("{} disposing {}", this.getLabel(), (Object)StringTools.safeString(value));
            ((IDisposable)value).dispose();
        }
        this.attributes.clear();
        Log.info("{} disposed", this.getLabel());
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected ExpirationPredicate getDefaultExpiration() {
        return new ExpireTimeout(300000L);
    }

    public ExpirationPredicate getExpiration() {
        return this.expiration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected Object getLabel() {
        return this.label;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalUpTime() {
        return System.currentTimeMillis() - this.getStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.lock;
        synchronized (object) {
            return this.disposed;
        }
    }

    @Override
    public boolean isExpired() {
        if (this.isDisposed()) {
            return true;
        }
        return this.getExpiration().isExpired();
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        if (this.isDisposed()) {
            return null;
        }
        return this.attributes.setAttribute(key, value);
    }

    public void setExpiration(ExpirationPredicate expiration) {
        Objects.requireNonNull(expiration, "expiration cannot be null");
        this.expiration = expiration;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public void touch() {
        this.getExpiration().touch();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent(this, attribute, oldValue, newValue);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException e) {
            Log.error("unexpected exception in CommonSession.triggerEvent", (Throwable)e);
        }
    }
}

