/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.session;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.session.IActivityContext;

public class StandardActivityContext
implements IActivityContext {
    private final AttributeMap attributes = new AttributeMap();
    private int ref;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object acquire() {
        Object object = this.lock;
        synchronized (object) {
            ++this.ref;
        }
        return null;
    }

    protected void basicRelease() {
        Object[] keys;
        for (Object key : keys = this.attributes.getKeys()) {
            Object value = this.attributes.get(key);
            if (!(value instanceof IDisposable)) continue;
            ((IDisposable)value).dispose();
        }
        this.attributes.clear();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReferenceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean release(Object handle) {
        int tempRef;
        Object object = this.lock;
        synchronized (object) {
            tempRef = --this.ref;
        }
        if (tempRef == 0) {
            this.basicRelease();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(Object key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ref <= 0) {
                throw new InvalidRequestException("IActivityContext not active");
            }
            return this.attributes.removeAttribute(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ref <= 0) {
                throw new InvalidRequestException("IActivityContext not active");
            }
            return this.attributes.setAttribute(key, value);
        }
    }
}

