/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.serialize.BONSerializationFactory;
import de.intarsys.tools.serialize.IDeserializer;
import de.intarsys.tools.serialize.ISerializer;
import de.intarsys.tools.serialize.StreamSerializationContext;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BONTools {
    public static Object deserialize(byte[] value) throws IOException {
        BONSerializationFactory factory = new BONSerializationFactory();
        StreamSerializationContext context = new StreamSerializationContext(value);
        IDeserializer deserializer = factory.createDeserializer(context);
        return deserializer.deserialize();
    }

    public static Object deserialize(String value) throws IOException {
        BONSerializationFactory factory = new BONSerializationFactory();
        StreamSerializationContext context = new StreamSerializationContext(value);
        IDeserializer deserializer = factory.createDeserializer(context);
        return deserializer.deserialize();
    }

    public static void flatten(Object object, String prefix, Map<String, String> map) throws IOException {
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                Object nestedPrefix = StringTools.isEmpty(prefix) ? key : prefix + "." + key;
                BONTools.flatten(value, (String)nestedPrefix, map);
            }
        } else if (object instanceof Object[]) {
            int i = 0;
            for (Object value : Arrays.asList((Object[])object)) {
                String nestedPrefix = StringTools.isEmpty(prefix) ? "" + i : prefix + "." + i;
                BONTools.flatten(value, nestedPrefix, map);
            }
        } else if (object instanceof List) {
            int i = 0;
            for (Object value : (List)object) {
                String nestedPrefix = StringTools.isEmpty(prefix) ? "" + i : prefix + "." + i;
                BONTools.flatten(value, nestedPrefix, map);
            }
        } else if (object instanceof IArgs) {
            IArgs args = (IArgs)object;
            int i = 0;
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                Object value = binding.getValue();
                Object name = binding.getName() == null ? "" + i : binding.getName();
                Object nestedPrefix = StringTools.isEmpty(prefix) ? name : prefix + "." + (String)name;
                BONTools.flatten(value, (String)nestedPrefix, map);
                ++i;
            }
        } else {
            String serialized = BONTools.serializeString(object);
            map.put(prefix, serialized);
        }
    }

    public static boolean isSupported(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        return value instanceof byte[];
    }

    public static byte[] serializeBytes(Object value) throws IOException {
        BONSerializationFactory factory = new BONSerializationFactory();
        StreamSerializationContext context = new StreamSerializationContext();
        ISerializer serializer = factory.createSerializer(context);
        serializer.serialize(value);
        return context.getBytes();
    }

    public static String serializeString(Object value) throws IOException {
        BONSerializationFactory factory = new BONSerializationFactory();
        StreamSerializationContext context = new StreamSerializationContext();
        ISerializer serializer = factory.createSerializer(context);
        serializer.serialize(value);
        return new String(context.getBytes(), StandardCharsets.UTF_8);
    }

    private BONTools() {
    }
}

