/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public final class SAXTools {
    private static final String PROP_VALUE = "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl";
    private static final String PROP_JAVAX_XML_PARSERS_SAX_PARSER_FACTORY = "javax.xml.parsers.SAXParserFactory";

    public static SAXParserFactory createSecureParserFactory() throws SAXException, ParserConfigurationException {
        String parserFactoryName = System.getProperty(PROP_JAVAX_XML_PARSERS_SAX_PARSER_FACTORY);
        if (parserFactoryName == null) {
            System.setProperty(PROP_JAVAX_XML_PARSERS_SAX_PARSER_FACTORY, PROP_VALUE);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        return factory;
    }

    public static Object deserialize(char[] ch) throws IOException {
        return SAXTools.deserialize(ch, 0, ch.length);
    }

    public static Object deserialize(char[] ch, int start, int length) throws IOException {
        return SAXTools.deserialize(new String(ch, start, length));
    }

    public static Object deserialize(String value) throws IOException {
        Object object;
        ObjectInputStream objectStream = null;
        try {
            byte[] decodedValue = Base64.decode(value);
            ByteArrayInputStream byteArrayStream = new ByteArrayInputStream(decodedValue);
            objectStream = new ObjectInputStream(byteArrayStream);
            object = objectStream.readObject();
            objectStream.close();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                StreamTools.close(objectStream);
                throw throwable;
            }
        }
        StreamTools.close(objectStream);
        return object;
    }

    public static char[] serializeToCharArray(Object object) {
        return SAXTools.serializeToString(object).toCharArray();
    }

    public static String serializeToString(Object object) {
        ByteArrayOutputStream byteArrayStream;
        try {
            byteArrayStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteArrayStream);
            objectStream.writeObject(object);
            objectStream.close();
        }
        catch (IOException ignore) {
            return "";
        }
        byte[] byteValue = byteArrayStream.toByteArray();
        return new String(Base64.encode(byteValue));
    }

    private SAXTools() {
    }
}

