/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassTools {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();

    public static List<Class<?>> collectClasses(String classPath) throws IOException {
        List<String> classNames = ClassTools.collectClassNames(classPath);
        ClassLoader loader = ClassTools.createClassLoader(classPath);
        ArrayList classes = new ArrayList();
        for (String className : classNames) {
            try {
                classes.add(loader.loadClass(className));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return classes;
    }

    public static List<String> collectClassNames(String classPath) throws IOException {
        ArrayList<String> classnames = new ArrayList<String>();
        StringTokenizer path = new StringTokenizer(classPath, PATH_SEPARATOR);
        int pathCount = path.countTokens();
        for (int ii = 0; ii < pathCount; ++ii) {
            String currentName = path.nextToken();
            File currentFile = new File(currentName);
            if (currentFile.isFile()) {
                ClassTools.extractClassNamesFromJar(classnames, currentFile);
                continue;
            }
            ClassTools.extractClassNamesFromDir(classnames, currentFile, "");
        }
        return classnames;
    }

    public static <T> Class<T> createClass(String className, Class<T> expectedClass, ClassLoader classLoader) throws ObjectCreationException {
        if (StringTools.isEmpty(className)) {
            throw new ObjectCreationException("class name missing");
        }
        className = Aliases.get().resolve(className.trim());
        try {
            Class<?> clazz;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = expectedClass == null ? ClassTools.class.getClassLoader() : expectedClass.getClassLoader();
            }
            if ((clazz = PRIMITIVE_TYPES.get(className)) == null) {
                clazz = Class.forName(className, false, classLoader);
            }
            if (expectedClass != null && !expectedClass.isAssignableFrom(clazz)) {
                throw new ObjectCreationException("class '" + clazz.getName() + "' not compatible with expected type '" + expectedClass + "'");
            }
            return clazz;
        }
        catch (Throwable e) {
            throw new ObjectCreationException("class '" + className + "' not found", e);
        }
    }

    public static ClassLoader createClassLoader(String classPath) {
        URL[] allURLs = null;
        StringTokenizer path = new StringTokenizer(classPath, PATH_SEPARATOR);
        int i = path.countTokens();
        allURLs = new URL[i + 1];
        for (int ii = 0; ii < i; ++ii) {
            String currentPath = path.nextToken();
            try {
                URL url;
                allURLs[ii] = url = new URL("file", "", currentPath);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URLClassLoader loader = URLClassLoader.newInstance(allURLs);
        return loader;
    }

    protected static void extractClassNamesFromDir(List<String> result, File currentFile, String relativePath) throws IOException {
        if (currentFile.isFile()) {
            String filename = currentFile.getName();
            if (filename.endsWith(".class")) {
                String className = filename.substring(0, filename.length() - 6);
                result.add(relativePath + className);
            }
        } else {
            String[] allFiles = currentFile.list();
            if (allFiles == null) {
                throw new IOException("error creating directory listing for " + currentFile.getAbsolutePath());
            }
            for (int i = 0; i < allFiles.length; ++i) {
                File child = new File(currentFile, allFiles[i]);
                ClassTools.extractClassNamesFromDir(result, child, relativePath + allFiles[i] + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void extractClassNamesFromJar(List<String> result, File file) throws IOException {
        try (JarFile jar = null;){
            jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6);
                className = className.replace('/', '.');
                result.add(className);
            }
        }
    }

    public static String getConstantName(Class<?> clazz, Object searchValue) {
        if (searchValue == null) {
            return null;
        }
        Optional<String> constantName = Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> {
            try {
                Object constantValue = field.get(null);
                return constantValue != null && constantValue.equals(searchValue);
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }).findFirst().map(field -> field.getName());
        if (constantName.isPresent()) {
            return constantName.get();
        }
        for (Class<?> interfac : clazz.getInterfaces()) {
            String name = ClassTools.getConstantName(interfac, searchValue);
            if (name == null) continue;
            return name;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return ClassTools.getConstantName(clazz.getSuperclass(), searchValue);
        }
        return null;
    }

    public static URL getContainerResourceUrl(Class<?> clazz) {
        String resourceName;
        String tmpName = "/" + clazz.getName().replace(".", "/") + ".class";
        URL resourceUrl = clazz.getResource(tmpName);
        if (resourceUrl != null && (resourceName = resourceUrl.toString()).endsWith(tmpName)) {
            try {
                resourceUrl = new URL(resourceName.substring(0, resourceName.length() - tmpName.length() + 1));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ClassTools.getContainerResourceUrl(resourceUrl);
    }

    public static URL getContainerResourceUrl(URL resourceUrl) {
        String tmpPath;
        int tmpPos;
        if (resourceUrl.getProtocol().equals("jar")) {
            String tmpPath2 = resourceUrl.toString();
            int tmpPos2 = (tmpPath2 = tmpPath2.substring(4)).indexOf("!");
            if (tmpPos2 >= 0) {
                tmpPath2 = tmpPath2.substring(0, tmpPos2);
            }
            try {
                return new URL(tmpPath2);
            }
            catch (MalformedURLException malformedURLException) {
            }
        } else if (resourceUrl.getProtocol().equals("file") && (tmpPos = (tmpPath = resourceUrl.toString()).indexOf("/WEB-INF/")) >= 0) {
            tmpPath = tmpPath.substring(0, tmpPos + 1);
            try {
                return new URL(tmpPath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return resourceUrl;
    }

    public static String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        return ClassTools.getPackageName(name);
    }

    public static String getPackageName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(0, pos);
        }
        return "";
    }

    public static String getUnqualifiedName(Class<?> clazz) {
        String name = clazz.getName();
        return ClassTools.getUnqualifiedName(name);
    }

    public static String getUnqualifiedName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    private ClassTools() {
    }

    static {
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
    }
}

