/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.IUnEscaper;
import de.intarsys.tools.stream.StreamTools;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class UnEscapeReader
extends FilterReader
implements IUnEscaper {
    public static final char DEFAULT_ESCAPE = '\\';
    private static final Map DEFAULT_ESCAPE_MAP = new HashMap();
    private char escape = (char)92;
    private Map escapeMap = DEFAULT_ESCAPE_MAP;
    private boolean mapped;
    private char unicodePrefix = (char)117;
    private boolean ignoreUndefinedEscape;

    public static String unescape(String in) throws IOException {
        UnEscapeReader reader = new UnEscapeReader(new StringReader(in));
        return StreamTools.getString(reader);
    }

    public UnEscapeReader(Reader in) {
        super(in);
    }

    public UnEscapeReader(Reader in, boolean ignoreUndefinedEscape) {
        super(in);
        this.setIgnoreUndefinedEscape(ignoreUndefinedEscape);
    }

    public UnEscapeReader(Reader in, char escape, Map map) {
        super(in);
        this.escape = escape;
        this.escapeMap = map;
    }

    public UnEscapeReader(Reader in, char escape, Map map, boolean ignoreUndefinedEscape) {
        super(in);
        this.escape = escape;
        this.escapeMap = map;
        this.setIgnoreUndefinedEscape(ignoreUndefinedEscape);
    }

    public UnEscapeReader(Reader in, Map map) {
        super(in);
        this.escapeMap = map;
    }

    public UnEscapeReader(Reader in, Map map, boolean ignoreUndefinedEscape) {
        super(in);
        this.escapeMap = map;
        this.setIgnoreUndefinedEscape(ignoreUndefinedEscape);
    }

    @Override
    public void addEscapedCharacter(char key, char value) {
        Map tempMap = this.getEscapeMap();
        tempMap.put(Character.valueOf(key), Character.valueOf(value));
        this.setEscapeMap(tempMap);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public char getEscape() {
        return this.escape;
    }

    public Map getEscapeMap() {
        return new HashMap(this.escapeMap);
    }

    public char getUnicodePrefix() {
        return this.unicodePrefix;
    }

    public final boolean isIgnoreUndefinedEscape() {
        return this.ignoreUndefinedEscape;
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public int read() throws IOException {
        this.mapped = false;
        int i = this.in.read();
        if (i == this.escape) {
            this.mapped = true;
            i = this.readEscaped();
        }
        return i;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        int pos;
        int stop = off + len;
        if (off < 0 || off >= cbuf.length || len < 0 || stop > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (pos = off; pos < stop && (i = this.read()) != -1; ++pos) {
            cbuf[pos] = (char)i;
        }
        if (pos == off) {
            return -1;
        }
        return pos - off;
    }

    protected int readEscaped() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            return -1;
        }
        if ((char)i == '\r') {
            int next = this.read();
            if ((char)next == '\n' && !this.isMapped()) {
                return this.read();
            }
            return next;
        }
        if ((char)i == '\n') {
            return this.read();
        }
        if ((char)i == this.getUnicodePrefix()) {
            return this.readHex();
        }
        Character key = Character.valueOf((char)i);
        Character value = (Character)this.escapeMap.get(key);
        if (value == null) {
            if (this.escapeMap.containsKey(key)) {
                return this.read();
            }
            if (this.isIgnoreUndefinedEscape()) {
                return i;
            }
            throw new IOException("unrecognized escape sequence: \"\\" + (char)i + "\"");
        }
        return value.charValue();
    }

    protected int readHex() throws IOException {
        StringBuilder buf = new StringBuilder();
        int ch = this.in.read();
        while (((char)ch >= '0' && (char)ch <= '9' || (char)ch >= 'A' && (char)ch <= 'F' || (char)ch >= 'a' && (char)ch <= 'f') && buf.length() < 4) {
            buf.append((char)ch);
            ch = this.in.read();
        }
        if (ch == -1) {
            return -1;
        }
        if (buf.length() < 4) {
            throw new IOException("illegal escape sequence: \"\\u" + buf.toString() + "\"");
        }
        String hexString = new String(buf);
        return Integer.parseInt(hexString, 16);
    }

    public void removeEscapedCharacter(char key) {
        Map tempMap = this.getEscapeMap();
        tempMap.remove(Character.valueOf(key));
        this.setEscapeMap(tempMap);
    }

    public void removeEscapedCharacters() {
        this.setEscapeMap(new HashMap());
    }

    @Override
    public void setEscape(char newEscape) {
        if (newEscape == this.escape) {
            return;
        }
        Map tempMap = this.getEscapeMap();
        tempMap.remove(Character.valueOf(this.getEscape()));
        tempMap.put(Character.valueOf(newEscape), Character.valueOf(newEscape));
        this.setEscapeMap(tempMap);
        this.escape = newEscape;
    }

    protected void setEscapeMap(Map newEscapeMap) {
        this.escapeMap = newEscapeMap;
    }

    public final void setIgnoreUndefinedEscape(boolean ignoreUndefinedEscape) {
        this.ignoreUndefinedEscape = ignoreUndefinedEscape;
    }

    public void setUnicodePrefix(char newUniChar) {
        this.unicodePrefix = newUniChar;
    }

    @Override
    public long skip(long n) throws IOException {
        long actual;
        if (n < 0L) {
            throw new IOException("parameter is negative");
        }
        int ch = 0;
        for (actual = 0L; actual < n && ch != -1; ++actual) {
            ch = this.read();
        }
        return actual;
    }

    static {
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('\\'), Character.valueOf('\\'));
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('n'), Character.valueOf('\n'));
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('r'), Character.valueOf('\r'));
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('t'), Character.valueOf('\t'));
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('\n'), null);
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('\r'), null);
        DEFAULT_ESCAPE_MAP.put(Character.valueOf('\t'), null);
        DEFAULT_ESCAPE_MAP.put(Character.valueOf(' '), null);
    }
}

