/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.provider;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Providers {
    public static final char COMMENT = '#';
    public static final String SEPARATOR = ";";
    private static final Map<ClassLoader, Providers> PROVIDERS = new ConcurrentHashMap<ClassLoader, Providers>();
    private static final String PROVIDERLIST = "META-INF/provider/provider.list";
    private static final Logger Log = LoggerFactory.getLogger((String)"de.intarsys.tools.provider");
    private ClassLoader loader;
    private List<ProviderEntry> entries = new ArrayList<ProviderEntry>();

    public static Providers get() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return Providers.get(classLoader);
    }

    public static Providers get(ClassLoader classloader) {
        return PROVIDERS.computeIfAbsent(classloader, key -> new Providers(classloader));
    }

    protected Providers(ClassLoader cl) {
        this.loader = cl;
        try {
            this.init();
        }
        catch (IOException e) {
            Log.warn("loading provider definitions failed ({})", (Object)ExceptionTools.getMessage(e));
        }
    }

    protected void addProvider(ProviderEntry entry) {
        for (ProviderEntry temp : this.entries) {
            if (!temp.serviceName.equals(entry.serviceName) || !temp.providerName.equals(entry.providerName)) continue;
            return;
        }
        this.entries.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        Enumeration<URL> providerlistUrls = this.loader == null ? ClassLoader.getSystemResources(PROVIDERLIST) : this.loader.getResources(PROVIDERLIST);
        while (providerlistUrls.hasMoreElements()) {
            URL providerlistUrl = providerlistUrls.nextElement();
            InputStream is = null;
            try {
                is = providerlistUrl.openStream();
                this.register(is);
            }
            finally {
                StreamTools.close(is);
            }
        }
    }

    public <S> Iterator<S> lookupProviders(final Class<S> service) {
        return new Iterator<S>(){
            private Object current;
            private String serviceName;
            private Iterator<ProviderEntry> it;
            {
                this.serviceName = service.getName();
                this.it = Providers.this.entries.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                while (this.it.hasNext()) {
                    ProviderEntry providerEntry = this.it.next();
                    if (!this.serviceName.equals(providerEntry.serviceName)) continue;
                    if (!providerEntry.provider.isDone()) {
                        try {
                            providerEntry.provider.complete(Class.forName(providerEntry.providerName, true, Providers.this.loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (Throwable t) {
                            Log.warn("loading provider for {} failed ({})", (Object)providerEntry.serviceName, (Object)ExceptionTools.getMessage(t));
                            providerEntry.provider.completeExceptionally(t);
                        }
                    }
                    if (providerEntry.provider.isCompletedExceptionally()) continue;
                    this.current = ExceptionTools.futureSimpleGet(providerEntry.provider);
                    return true;
                }
                return false;
            }

            @Override
            public S next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object provider = this.current;
                this.current = null;
                return provider;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void register(InputStream is) throws IOException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while (this.registerLine(r)) {
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(r);
            throw throwable;
        }
        StreamTools.close(r);
    }

    protected boolean registerLine(BufferedReader r) throws IOException {
        String ln = r.readLine();
        if (ln == null) {
            return false;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((ln = ln.trim()).length() == 0) {
            return true;
        }
        String[] parts = ln.split(SEPARATOR);
        if (parts.length < 2) {
            return true;
        }
        ProviderEntry entry = new ProviderEntry();
        entry.serviceName = parts[0].trim();
        entry.providerName = parts[1].trim();
        this.addProvider(entry);
        return true;
    }

    static class ProviderEntry {
        protected String serviceName;
        protected String providerName;
        protected CompletableFuture<Object> provider = new CompletableFuture();

        ProviderEntry() {
        }
    }
}

