/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.pool;

import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.pool.IPoolObjectFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public class GenericPool<T>
implements IPool<T> {
    private final IPoolObjectFactory<T> objectFactory;
    private final Deque<T> objects;
    private boolean closed;

    public GenericPool(IPoolObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.objects = new ArrayDeque<T>();
        this.closed = false;
    }

    protected void activateObject(T object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.activateObject(object);
    }

    protected void assertOpen() {
        if (this.closed) {
            throw new InvalidRequestException("pool closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkin(T object) throws Exception {
        this.deactivateObject(object);
        GenericPool genericPool = this;
        synchronized (genericPool) {
            this.assertOpen();
            this.objects.addLast(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T checkout(long timeout) throws Exception {
        T result = null;
        GenericPool genericPool = this;
        synchronized (genericPool) {
            this.assertOpen();
            result = this.objects.isEmpty() ? (T)this.createObject() : (T)this.objects.pop();
        }
        this.activateObject(result);
        return result;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
    }

    protected T createObject() throws Exception {
        if (this.objectFactory == null) {
            throw new IllegalStateException("can not create new object");
        }
        T result = this.objectFactory.createObject();
        if (result == null) {
            throw new IllegalStateException("new object can't be null");
        }
        return result;
    }

    protected void deactivateObject(T object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.deactivateObject(object);
    }

    @Override
    public void destroy(T object) throws Exception {
        this.destroyObject(object);
    }

    protected void destroyObject(T object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.destroyObject(object);
    }

    protected boolean isClosed() {
        return this.closed;
    }
}

