/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.notice;

import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.state.AtomicState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NoticeTools {
    public static final String CODE_ACTIVITY = "activity";
    public static final String CODE_VALIDATION = "validation";

    public static void attachActivityNotice(int severity, AtomicState state, IMessage message, INoticesSupport target) {
        NoticeTools.attachActivityNotice(severity, false, state, message, target);
    }

    public static void attachActivityNotice(int severity, boolean sticky, AtomicState state, IMessage message, INoticesSupport target) {
        String code = NoticeTools.getActivityCode(state.getId(), null);
        Notice notice = new Notice(severity, sticky, new AliasMessage(code, message, new Object[0]));
        target.addNotice(notice);
    }

    public static void clearNonSticky(INoticesSupport ns) {
        ArrayList<INotice> notices = new ArrayList<INotice>(ns.getNotices());
        for (INotice notice : notices) {
            if (notice.isSticky()) continue;
            ns.removeNotice(notice);
        }
    }

    public static String getActivityCode(String state, String context) {
        StringBuilder sb = new StringBuilder();
        sb.append(CODE_ACTIVITY);
        if (state != null) {
            sb.append(".");
            sb.append(state);
            if (context != null) {
                sb.append(":");
                sb.append(context);
            }
        }
        return sb.toString();
    }

    public static boolean hasError(INoticesSupport ns) {
        for (INotice notice : ns.getNotices()) {
            if (notice.getSeverity() != 30) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInfo(INoticesSupport ns) {
        for (INotice notice : ns.getNotices()) {
            if (notice.getSeverity() != 10) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotices(INoticesSupport ns) {
        return !ns.getNotices().isEmpty();
    }

    public static boolean hasWarning(INoticesSupport ns) {
        for (INotice notice : ns.getNotices()) {
            if (notice.getSeverity() != 20) continue;
            return true;
        }
        return false;
    }

    public static void setNotice(INoticesSupport ns, INotice newNotice) {
        for (INotice notice : ns.getNotices()) {
            if (notice.getSeverity() <= newNotice.getSeverity()) continue;
            return;
        }
        ns.clearNotices();
        ns.addNotice(newNotice);
    }

    public static List<INotice> sortBySeverity(INoticesSupport ns) {
        ArrayList<INotice> notices = new ArrayList<INotice>(ns.getNotices());
        Collections.sort(notices, new Comparator<INotice>(){

            @Override
            public int compare(INotice o1, INotice o2) {
                if (o1.getSeverity() < o2.getSeverity()) {
                    return 1;
                }
                if (o1.getSeverity() > o2.getSeverity()) {
                    return -1;
                }
                return 0;
            }
        });
        return notices;
    }

    private NoticeTools() {
    }
}

