/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.notice;

import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.notice.INotice;

public class Notice
implements INotice {
    private final int severity;
    private final IMessage message;
    private final boolean sticky;

    public Notice(IMessage message) {
        this(10, false, message);
    }

    public Notice(IMessageBundle bundle, int severity, boolean sticky, String code, Object ... args) {
        this(severity, sticky, bundle.getMessage(code, args));
    }

    public Notice(IMessageBundle bundle, String code, Object ... args) {
        this(10, false, bundle.getMessage(code, args));
    }

    public Notice(int severity, boolean sticky, IMessage message) {
        this.severity = severity;
        this.message = message;
        this.sticky = sticky;
    }

    public Notice(int severity, boolean sticky, String code, String text, Object ... args) {
        this(severity, sticky, LiteralMessage.create(code, text, args));
    }

    public Notice(String code, String text, Object ... args) {
        this(10, false, code, text, args);
    }

    @Override
    public Object getArgumentAt(int index) {
        return this.message.getArgumentAt(index);
    }

    @Override
    public int getArgumentSize() {
        return this.message.getArgumentSize();
    }

    @Override
    public String getCode() {
        return this.message.getCode();
    }

    public Object getDetail() {
        return this.getArgumentSize() > 0 ? this.getArgumentAt(0) : null;
    }

    @Override
    public String getPattern() {
        return this.message.getPattern();
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String getString() {
        return this.message.getString();
    }

    public String getText() {
        return this.message.getString();
    }

    public boolean isDebug() {
        return this.getSeverity() == 0;
    }

    public boolean isError() {
        return this.getSeverity() == 30;
    }

    public boolean isInfo() {
        return this.getSeverity() == 10;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public boolean isWarning() {
        return this.getSeverity() == 20;
    }

    public String toString() {
        return (switch (this.severity) {
            case 0 -> "DEBUG ";
            case 10 -> "INFO ";
            case 20 -> "WARNING ";
            case 30 -> "ERROR ";
            default -> throw new UnreachableCodeError();
        }) + this.message.toString();
    }
}

