/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.monitor.ISample;
import de.intarsys.tools.monitor.ITrace;
import java.util.List;
import org.slf4j.event.Level;

public class MultiTrace
implements ITrace {
    private Object trace;

    public boolean isEmpty() {
        return this.trace == null;
    }

    public void registerTrace(ITrace pTrace) {
        if (this.trace == null) {
            this.trace = pTrace;
        } else if (this.trace instanceof List) {
            ((List)this.trace).add(pTrace);
        } else {
            this.trace = ListTools.with((ITrace)this.trace, pTrace);
        }
    }

    @Override
    public ISample sample(Level level, String description) {
        if (this.trace == null) {
            return null;
        }
        if (this.trace instanceof List) {
            for (ITrace childTrace : (List)this.trace) {
                childTrace.sample(level, description);
            }
            return null;
        }
        return ((ITrace)this.trace).sample(level, description);
    }

    @Override
    public void stop() {
        if (this.trace != null) {
            if (this.trace instanceof List) {
                for (ITrace childTrace : (List)this.trace) {
                    childTrace.stop();
                }
            } else {
                ((ITrace)this.trace).stop();
            }
        }
    }

    @Override
    public void tag(String key, Object tag) {
        if (this.trace != null) {
            if (this.trace instanceof List) {
                for (ITrace childTrace : (List)this.trace) {
                    childTrace.tag(key, tag);
                }
            } else {
                ((ITrace)this.trace).tag(key, tag);
            }
        }
    }

    public void unregisterTrace(ITrace pTrace) {
        if (this.trace != null) {
            if (this.trace instanceof List) {
                ((List)this.trace).remove(pTrace);
                if (((List)this.trace).isEmpty()) {
                    this.trace = null;
                }
            } else if (this.trace == pTrace) {
                this.trace = null;
            }
        }
    }
}

