/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.functor.Args;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorRegistry;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MonitorFactory {
    public static List<IMonitor> createChildMonitors(IElement element, Object context) throws ObjectCreationException {
        IElement eMonitors = element.element("monitors");
        if (eMonitors != null) {
            return MonitorFactory.createMonitors(eMonitors, context);
        }
        return Collections.emptyList();
    }

    public static List<IMonitor> createMonitors(IElement element, Object context) throws ObjectCreationException {
        ArrayList<IMonitor> monitors = new ArrayList<IMonitor>();
        Iterator<IElement> it = element.elementIterator("monitor");
        while (it.hasNext()) {
            IElement eMonitor = it.next();
            IMonitor monitor = ElementTools.createObject(eMonitor, IMonitor.class, context, Args.create());
            monitors.add(monitor);
            MonitorRegistry.get().registerMonitor(monitor);
        }
        return monitors;
    }

    private MonitorFactory() {
    }
}

