/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PrefixedMessageBundle
implements IMessageBundle {
    private final String prefix;
    private final IMessageBundle messageBundle;

    public PrefixedMessageBundle(IMessageBundle messageBundle, String prefix) {
        Objects.requireNonNull(messageBundle, "messageBundle cannot be null");
        this.messageBundle = messageBundle;
        this.prefix = prefix;
    }

    protected String createKey(String key) {
        return this.prefix + "." + key;
    }

    @Override
    public String format(String pattern, Object ... args) {
        return this.getMessageBundle().format(pattern, args);
    }

    @Override
    public Set<String> getCodes() {
        return this.getMessageBundle().getCodes().stream().map(code -> this.createKey((String)code)).collect(Collectors.toSet());
    }

    @Override
    public IMessage getMessage(String key, Object ... arg) {
        return this.getMessageBundle().getMessage(this.createKey(key), new Object[0]);
    }

    public IMessageBundle getMessageBundle() {
        return this.messageBundle;
    }

    @Override
    public String getName() {
        return this.getMessageBundle().getName();
    }

    @Override
    public String getPattern(String key) {
        return this.getMessageBundle().getPattern(this.createKey(key));
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getString(String key, Object ... args) {
        return this.getMessageBundle().getString(this.createKey(key), args);
    }
}

