/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.FormattedObject;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Arrays;

public class GenericMessage
implements IMessage {
    private final IMessageBundle bundle;
    private final String code;
    private final Object[] args;
    private final Object[] formattedArgs;

    public GenericMessage(IMessageBundle bundle, String code, Object[] args) {
        this.bundle = bundle;
        this.code = code;
        if (args != null) {
            Object[] tempArgs = args;
            Object[] tempFormattedArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof FormattedObject)) continue;
                if (tempArgs == tempFormattedArgs) {
                    tempArgs = Arrays.copyOf(args, args.length);
                    tempFormattedArgs = Arrays.copyOf(args, args.length);
                }
                tempArgs[i] = ((FormattedObject)args[i]).getObject();
                tempFormattedArgs[i] = ((FormattedObject)args[i]).getFormattedObject();
            }
            this.args = tempArgs;
            this.formattedArgs = tempFormattedArgs;
        } else {
            this.args = null;
            this.formattedArgs = null;
        }
    }

    @Override
    public Object getArgumentAt(int index) {
        if (this.args == null || index < 0 || index >= this.args.length) {
            return null;
        }
        return this.args[index];
    }

    @Override
    public int getArgumentSize() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    public IMessageBundle getBundle() {
        return this.bundle;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public Object[] getFormattedArgs() {
        return this.formattedArgs;
    }

    public String getKey() {
        return this.getCode();
    }

    @Override
    public String getPattern() {
        return this.getBundle().getPattern(this.code);
    }

    @Override
    public String getString() {
        return this.getBundle().getString(this.code, this.formattedArgs);
    }

    public String toString() {
        return this.getString();
    }
}

