/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.CommonMessageBundleFactory;
import de.intarsys.tools.nls.NlsContext;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class BasicMessageBundle
extends CommonMessageBundle {
    private ResourceBundle resourceBundle;
    private final Locale locale;
    private ResourceBundle.Control control = new ResourceBundle.Control(){

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            Locale defaultLocale = NlsContext.get().getLocale();
            return locale.equals(defaultLocale) ? null : defaultLocale;
        }
    };

    protected BasicMessageBundle(CommonMessageBundleFactory factory, String name, Locale locale, ClassLoader classLoader) {
        super(factory, name, classLoader);
        this.locale = locale;
    }

    protected Object basicGetObject(String code) {
        try {
            ResourceBundle myBundle = this.getResourceBundle();
            if (myBundle != null) {
                return myBundle.getObject(code);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected ResourceBundle createResourceBundle() {
        if (this.getClassLoader() == null) {
            return ResourceBundle.getBundle(this.getName(), this.getLocale(), this.control);
        }
        return ResourceBundle.getBundle(this.getName(), this.getLocale(), this.getClassLoader(), this.control);
    }

    @Override
    public Set<String> getCodes() {
        try {
            ResourceBundle myBundle = this.getResourceBundle();
            if (myBundle != null) {
                return myBundle.keySet();
            }
            return Collections.emptySet();
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getPattern(String code) {
        try {
            ResourceBundle myBundle = this.getResourceBundle();
            if (myBundle != null) {
                return myBundle.getString(code);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = this.createResourceBundle();
        }
        return this.resourceBundle;
    }

    @Override
    public String getString(String code, Object ... args) {
        String pattern = this.getPattern(code);
        if (pattern == null) {
            return this.getFallbackString(code, args);
        }
        return this.format(pattern, args);
    }
}

