/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;

public class LocatorViewport
extends CommonLocator
implements IAdapterSupport {
    private ILocator delegate;
    private long start;
    private long end = -1L;
    private String name;

    public LocatorViewport(ILocator delegate) {
        this.setDelegate(delegate);
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.getDelegate().exists();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        return AdapterTools.getAdapter(this.delegate, clazz, null);
    }

    @Override
    public ILocator getChild(String name) {
        return this.getDelegate().getChild(name);
    }

    public ILocator getDelegate() {
        return this.delegate;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new InputStreamProxy(this.getDelegate().getInputStream());
    }

    @Override
    public long getLength() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDelegate().getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public ILocator getParent() {
        return this.getDelegate().getParent();
    }

    @Override
    public String getPath() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.getDelegate().getPath();
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        return new RandomAccessProxy(this.getDelegate().getRandomAccess());
    }

    @Override
    public Reader getReader() throws IOException {
        return new ReaderProxy(this.getDelegate().getReader());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return new ReaderProxy(this.getDelegate().getReader(encoding));
    }

    public long getStart() {
        return this.start;
    }

    @Override
    public Writer getWriter() throws IOException {
        return null;
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return this.getDelegate().isDirectory();
    }

    @Override
    public boolean isOutOfSynch() {
        return this.getDelegate().isOutOfSynch();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return this.getDelegate().listLocators(filter);
    }

    @Override
    public void rename(String newName) throws IOException {
        this.getDelegate().rename(newName);
    }

    protected void setDelegate(ILocator delegate) {
        this.delegate = delegate;
    }

    public void setEnd(long end) {
        try {
            if (end < 0L || end > this.getDelegate().getLength()) {
                throw new IllegalArgumentException("end");
            }
        }
        catch (IOException e) {
            throw ExceptionTools.wrap(e);
        }
        this.end = end;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(long start) {
        try {
            if (start < 0L || start > this.getDelegate().getLength()) {
                throw new IllegalArgumentException("start");
            }
        }
        catch (IOException e) {
            throw ExceptionTools.wrap(e);
        }
        this.start = start;
    }

    @Override
    public void synch() {
        this.getDelegate().synch();
    }

    @Override
    public URI toURI() {
        return this.getDelegate().toURI();
    }

    private class InputStreamProxy
    extends InputStream {
        private InputStream is;
        private int current;

        public InputStreamProxy(InputStream is) {
            this.is = is;
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public int read() throws IOException {
            int i;
            while ((long)this.current < LocatorViewport.this.getStart()) {
                i = this.is.read();
                if (i == -1) {
                    return i;
                }
                ++this.current;
            }
            if (LocatorViewport.this.getEnd() != -1L && (long)this.current >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            i = this.is.read();
            if (i != -1) {
                this.current += i;
            }
            return i;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            while ((long)this.current < LocatorViewport.this.getStart()) {
                i = this.is.read();
                if (i == -1) {
                    return i;
                }
                ++this.current;
            }
            if (LocatorViewport.this.getEnd() != -1L && (long)this.current >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            i = this.is.read(b, off, len);
            if (i != -1) {
                this.current += i;
            }
            return i;
        }
    }

    private class RandomAccessProxy
    extends AbstractRandomAccess {
        private IRandomAccess ra;
        private long ptrHost;

        public RandomAccessProxy(IRandomAccess ra) {
            this.ra = ra;
            try {
                this.seek(0L);
            }
            catch (IOException e) {
                throw ExceptionTools.wrap(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.ra.close();
        }

        @Override
        public void flush() throws IOException {
            this.ra.flush();
        }

        @Override
        public long getLength() throws IOException {
            return Math.min(LocatorViewport.this.getEnd(), this.ra.getLength()) - LocatorViewport.this.getStart();
        }

        @Override
        public long getOffset() throws IOException {
            return this.ra.getOffset() - LocatorViewport.this.getStart();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public int read() throws IOException {
            if (this.ptrHost < LocatorViewport.this.getStart()) {
                throw new IOException("index out of scope");
            }
            if (LocatorViewport.this.getEnd() != -1L && this.ptrHost >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            int i = this.ra.read();
            ++this.ptrHost;
            return i;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            if (this.ptrHost < LocatorViewport.this.getStart()) {
                throw new IOException("index out of scope");
            }
            if (LocatorViewport.this.getEnd() != -1L && this.ptrHost >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            int numBytes = Math.min(buffer.length, (int)LocatorViewport.this.getEnd() - (int)this.ptrHost);
            int i = this.ra.read(buffer, 0, numBytes);
            this.ptrHost += (long)i;
            return i;
        }

        @Override
        public int read(byte[] buffer, int start, int numBytes) throws IOException {
            if (this.ptrHost < LocatorViewport.this.getStart()) {
                throw new IOException("index out of scope");
            }
            if (LocatorViewport.this.getEnd() != -1L && this.ptrHost >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            numBytes = Math.min(numBytes, (int)LocatorViewport.this.getEnd() - (int)this.ptrHost);
            int i = this.ra.read(buffer, start, numBytes);
            this.ptrHost += (long)i;
            return i;
        }

        @Override
        public void seek(long offset) throws IOException {
            this.ra.seek(LocatorViewport.this.getStart() + offset);
            this.ptrHost = LocatorViewport.this.getStart() + offset;
        }

        @Override
        public void seekBy(long delta) throws IOException {
            this.ra.seek(this.ptrHost + delta);
            this.ptrHost += delta;
        }

        @Override
        public void setLength(long newLength) throws IOException {
        }

        @Override
        public void write(byte[] buffer) throws IOException {
        }

        @Override
        public void write(byte[] buffer, int start, int numBytes) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private class ReaderProxy
    extends Reader {
        private Reader r;
        private int current;

        public ReaderProxy(Reader r) {
            this.r = r;
        }

        @Override
        public void close() throws IOException {
            this.r.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            while ((long)this.current < LocatorViewport.this.getStart()) {
                this.r.read();
                ++this.current;
            }
            if ((long)this.current >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            len = Math.min(len, (int)LocatorViewport.this.getEnd() - this.current);
            int i = this.r.read(cbuf, off, len);
            this.current += i;
            return i;
        }
    }
}

