/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.content.ICharsetAccess;
import de.intarsys.tools.content.ICharsetSupport;
import de.intarsys.tools.content.IMimeTypeAccess;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ClassLoaderResourceLocatorFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorFactorySupport;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorWithArgs;
import de.intarsys.tools.locator.LookupLocatorFactory;
import de.intarsys.tools.locator.SchemeBasedLocatorFactory;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.reader.TaggedReader;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.IValueHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;

public class LocatorTools {
    public static final String PATH_SEPARATOR = ";";
    private static final long MAX_BUFFER_SIZE = 0xA00000L;

    public static void checkHash(ILocator locator, Object hash) throws IOException {
        Objects.requireNonNull(locator);
        IDigest digest = DigestTools.createDigest(hash);
        if (digest == null) {
            return;
        }
        IDigest docDigest = LocatorTools.digest(locator, digest.getAlgorithmName());
        if (!digest.equals(docDigest)) {
            throw new IOException("document digest validation failed (" + locator.getPath() + ")");
        }
    }

    @Deprecated
    public static void checkHash(ILocator locator, String algorithmName, Object hash) throws IOException {
        LocatorTools.checkHash(locator, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ILocator source, ILocator target) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = source.getInputStream();
            os = target.getOutputStream();
            StreamTools.copy(is, os);
        }
        finally {
            StreamTools.close(is);
            StreamTools.close(os);
        }
    }

    public static void copyRecursively(ILocator source, ILocator target) throws IOException {
        if (source.isDirectory()) {
            for (ILocator child : source.listLocators(null)) {
                LocatorTools.copyRecursively(child, target.getChild(child.getName()));
            }
        } else {
            LocatorTools.copy(source, target);
        }
    }

    public static File copyToTempFile(ILocator locator) throws IOException {
        File tempFile = FileTools.createTempFile(locator.getName());
        LocatorTools.save(locator, tempFile);
        return tempFile;
    }

    public static ILocator createLocator(Object value, ILocatorFactory factory, ILocator defaultValue) throws IOException {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof ILocator) {
            return (ILocator)value;
        }
        if (value instanceof ILocatorSupport) {
            return ((ILocatorSupport)value).getLocator();
        }
        if (value instanceof IArgs) {
            ILocator resultLocator = null;
            IArgs tempArgs = (IArgs)value;
            String charset = ArgTools.getString(tempArgs, "charset", null);
            String contentType = ArgTools.getString(tempArgs, "contentType", null);
            Object tempLocator = tempArgs.get("locator");
            if (tempLocator == null) {
                tempLocator = tempArgs.get("path");
            }
            if (tempLocator != null) {
                resultLocator = LocatorTools.createLocator(tempLocator, factory, null);
            }
            if (resultLocator == null) {
                String name = ArgTools.getString(tempArgs, "name", "locator.bytes");
                name = PathTools.getName(name);
                Object tempContent = tempArgs.get("text");
                if (tempContent == null) {
                    tempContent = tempArgs.get("content");
                    if (tempContent == null) {
                        tempContent = tempArgs.get("bytes");
                    }
                    if (tempContent == null) {
                        resultLocator = null;
                    } else if (tempContent instanceof ILocator) {
                        resultLocator = (ILocator)tempContent;
                    } else if (tempContent instanceof byte[]) {
                        resultLocator = new ByteArrayLocator((byte[])tempContent, name);
                    } else if (tempContent instanceof String) {
                        byte[] bytes = Base64.decode((String)tempContent);
                        resultLocator = new ByteArrayLocator(bytes, name);
                    } else {
                        try {
                            byte[] bytes = ConverterRegistry.get().convert(tempContent, byte[].class);
                            resultLocator = bytes == null ? null : new ByteArrayLocator(bytes, name);
                        }
                        catch (ConversionException bytes) {
                            // empty catch block
                        }
                        if (resultLocator == null) {
                            try {
                                String string = ConverterRegistry.get().convert(tempContent, String.class);
                                byte[] bytes = Base64.decode(string);
                                if (bytes == null) {
                                    resultLocator = null;
                                }
                                resultLocator = new ByteArrayLocator(bytes, name);
                            }
                            catch (ConversionException e) {
                                throw new IOException("can't create locator");
                            }
                        }
                    }
                } else {
                    resultLocator = new StringLocator(StringTools.safeString(tempContent), name);
                }
            }
            if (resultLocator != null) {
                IMimeTypeAccess contentTypeAccess;
                ICharsetAccess charsetAccess;
                if (charset != null && (charsetAccess = (ICharsetAccess)AdapterTools.getAdapter(resultLocator, ICharsetAccess.class, null)) != null) {
                    charsetAccess.setCharset(charset);
                }
                if (contentType != null && (contentTypeAccess = (IMimeTypeAccess)AdapterTools.getAdapter(resultLocator, IMimeTypeAccess.class, null)) != null) {
                    contentTypeAccess.setContentType(contentType);
                }
                try {
                    IDigest digest = ArgTools.getDigest(tempArgs, "hash");
                    LocatorTools.checkHash(resultLocator, digest);
                }
                catch (IOException e) {
                    throw new IOException("locator hash error", e);
                }
                if (ArgTools.getBoolStrict(tempArgs, "attachArgs", false)) {
                    resultLocator = new LocatorWithArgs(resultLocator, tempArgs);
                }
            }
            return resultLocator;
        }
        if (value instanceof byte[]) {
            return new ByteArrayLocator((byte[])value, "locator.bytes");
        }
        if (factory == null) {
            factory = LocatorFactory.get();
        }
        if (value instanceof File) {
            return factory.createLocator(((File)value).getAbsolutePath());
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return defaultValue;
            }
            return factory.createLocator((String)value);
        }
        try {
            return ConverterRegistry.get().convert(value, ILocator.class);
        }
        catch (ConversionException e) {
            throw new IOException("can't create locator", e);
        }
    }

    public static ILocatorFactory createLocatorFactory(final Object context) {
        if (context instanceof ILocatorFactory) {
            return (ILocatorFactory)context;
        }
        if (context instanceof ILocatorFactorySupport) {
            return ((ILocatorFactorySupport)context).getLocatorFactory();
        }
        SchemeBasedLocatorFactory sblf = new SchemeBasedLocatorFactory();
        if (context instanceof IFileEnvironment) {
            FileLocatorFactory flf = new FileLocatorFactory(new IValueHolder<File>(){

                @Override
                public File get() {
                    return ((IFileEnvironment)context).getBaseDir();
                }

                @Override
                public File set(File newValue) {
                    throw new UnsupportedOperationException();
                }
            });
            sblf.registerLocatorFactory("file", flf);
            sblf.setNoSchemeLocatorFactory(flf);
        }
        if (context instanceof IClassLoaderSupport) {
            ClassLoaderResourceLocatorFactory clrlf = new ClassLoaderResourceLocatorFactory(new IValueHolder<ClassLoader>(){

                @Override
                public ClassLoader get() {
                    return ((IClassLoaderSupport)context).getClassLoader();
                }

                @Override
                public ClassLoader set(ClassLoader newValue) {
                    throw new UnsupportedOperationException();
                }
            });
            sblf.registerLocatorFactory("classpath", clrlf);
        }
        return sblf;
    }

    public static ILocator[] createLocators(String paths, ILocatorFactory factory) throws IOException {
        if (factory == null) {
            factory = LocatorFactory.get();
        }
        ArrayList<ILocator> locators = new ArrayList<ILocator>();
        StringTokenizer t = new StringTokenizer(paths, PATH_SEPARATOR);
        while (t.hasMoreTokens()) {
            String path = t.nextToken();
            locators.add(factory.createLocator(path));
        }
        ILocator[] result = new ILocator[locators.size()];
        return locators.toArray(result);
    }

    public static ILocatorFactory createLookupFactory(Object ... contexts) {
        LookupLocatorFactory llf = new LookupLocatorFactory();
        for (Object context : contexts) {
            ILocatorFactory factory = LocatorTools.createLocatorFactory(context);
            if (factory == null) continue;
            llf.addLocatorFactory(factory);
        }
        return llf;
    }

    public static ILocator createTransientLocator(String name, long size) throws IOException {
        if (size >= 0L && size < 0xA00000L) {
            return new ByteArrayLocator(new byte[(int)size], 0, name);
        }
        File tempFile = FileTools.createTempFile(name);
        return new FileLocator(tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDigest digest(ILocator locator, IDigester digester) throws IOException {
        if (locator == null) {
            return null;
        }
        InputStream is = locator.getInputStream();
        try {
            IDigest iDigest = DigestTools.digest(digester, is);
            return iDigest;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static IDigest digest(ILocator locator, String algorithmName) throws IOException {
        try {
            IDigester digester = DigestTools.createDigester(algorithmName);
            return LocatorTools.digest(locator, digester);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String getBaseName(ILocator locator) {
        return LocatorTools.getBaseName(locator, null, "");
    }

    public static String getBaseName(ILocator locator, String extensionPrefix, String defaultName) {
        if (locator == null) {
            return defaultName;
        }
        return PathTools.getBaseName(locator.getName(), extensionPrefix, defaultName);
    }

    public static byte[] getBytes(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (locator instanceof ByteArrayLocator) {
            return ((ByteArrayLocator)locator).getBytes();
        }
        InputStream is = null;
        try {
            is = locator.getInputStream();
            byte[] byArray = StreamTools.getBytes(is);
            return byArray;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static String getExtension(ILocator locator) {
        return LocatorTools.getExtension(locator, null, "");
    }

    public static String getExtension(ILocator locator, String extensionPrefix, String defaultName) {
        if (locator == null) {
            return defaultName;
        }
        return PathTools.getExtension(locator.getName(), extensionPrefix, defaultName);
    }

    public static File getFile(ILocator locator) throws IOException {
        if (locator instanceof FileLocator) {
            return ((FileLocator)locator).getFile();
        }
        File file = FileTools.createTempFile(locator.getName());
        file.deleteOnExit();
        LocatorTools.save(locator, file);
        return file;
    }

    public static ILocator getRoot(ILocator locator) {
        ILocator root = locator;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public static String getString(ILocator locator) throws IOException {
        return LocatorTools.getString(locator, (String)null);
    }

    public static String getString(ILocator locator, Charset charset) throws IOException {
        return LocatorTools.getString(locator, charset == null ? null : charset.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(ILocator locator, String encoding) throws IOException {
        if (locator instanceof StringLocator) {
            return ((StringLocator)locator).getContent();
        }
        if (encoding == null) {
            encoding = locator instanceof ICharsetSupport ? ((ICharsetSupport)((Object)locator)).getCharset() : Charset.defaultCharset().name();
        }
        Reader r = null;
        try {
            r = locator.getReader(encoding);
            String string = StreamTools.getString(r);
            return string;
        }
        finally {
            StreamTools.close(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringAutoDetect(ILocator locator, String defaultEncoding) throws IOException {
        String string;
        if (locator instanceof StringLocator) {
            return ((StringLocator)locator).getContent();
        }
        BufferedInputStream is = null;
        TaggedReader r = null;
        try {
            is = new BufferedInputStream(locator.getInputStream(), 1024);
            if (defaultEncoding == null && locator instanceof ICharsetSupport) {
                defaultEncoding = ((ICharsetSupport)((Object)locator)).getCharset();
            }
            r = ReaderTools.createTaggedReader(is, defaultEncoding, 1024);
            string = StreamTools.getString(r);
        }
        catch (Throwable throwable) {
            StreamTools.close(r);
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close(r);
        StreamTools.close(is);
        return string;
    }

    public static ILocator makeUnique(ILocator locator) {
        if (locator == null) {
            return null;
        }
        if (locator.exists()) {
            int counter = 1;
            ILocator parentLocator = locator.getParent();
            if (parentLocator != null) {
                String basename = LocatorTools.getBaseName(locator);
                String extension = LocatorTools.getExtension(locator);
                while (locator.exists()) {
                    locator = parentLocator.getChild(basename + "." + counter++ + "." + extension);
                }
            }
        }
        return locator;
    }

    @Deprecated
    public static void putBytes(ILocator locator, byte[] bytes) throws IOException {
        LocatorTools.write(locator, bytes);
    }

    @Deprecated
    public static void putString(ILocator locator, String value) throws IOException {
        LocatorTools.write(locator, value);
    }

    @Deprecated
    public static void putString(ILocator locator, String value, String encoding) throws IOException {
        LocatorTools.write(locator, value, encoding);
    }

    public static void save(ILocator locator, File file) throws IOException {
        if (file.isDirectory()) {
            file = new File(file, locator.getName());
        }
        LocatorTools.copy(locator, new FileLocator(file));
    }

    public static void write(ILocator locator, byte[] bytes) throws IOException {
        if (locator == null) {
            return;
        }
        OutputStream os = null;
        try {
            os = locator.getOutputStream();
            os.write(bytes);
        }
        finally {
            StreamTools.close(os);
        }
    }

    public static void write(ILocator locator, String value) throws IOException {
        if (locator == null) {
            return;
        }
        Writer w = null;
        try {
            w = locator.getWriter();
            w.write(value);
        }
        finally {
            StreamTools.close(w);
        }
    }

    public static void write(ILocator locator, String value, Charset charset) throws IOException {
        LocatorTools.write(locator, value, charset.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ILocator locator, String value, String encoding) throws IOException {
        if (locator == null) {
            return;
        }
        Writer w = null;
        try {
            w = locator.getWriter(encoding);
            w.write(value);
        }
        finally {
            StreamTools.close(w);
        }
    }

    private LocatorTools() {
    }
}

