/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.URLLocator;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;
import java.net.URL;

public class HttpLocatorFactory
extends CommonLocatorFactory {
    private final String scheme;

    public HttpLocatorFactory(String scheme) {
        this.scheme = scheme;
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        String tempLocation = location.startsWith(this.getScheme()) ? location : this.getScheme() + ":" + location;
        return new URLLocator(new URL(tempLocation));
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendValue("HttpLocatorFactory (" + this.getScheme() + ")");
    }
}

