/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxb;

import de.intarsys.tools.locator.ILocator;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JAXBTools {
    private static final Object lock = new Object();
    private static final Map<Object, JAXBContext> contextsByPackageNames = new ConcurrentHashMap<Object, JAXBContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getContext(Class<?> clazz) throws JAXBException {
        String packageName = clazz.getPackage().getName();
        Object object = lock;
        synchronized (object) {
            JAXBContext context = contextsByPackageNames.get(packageName);
            if (context == null) {
                context = JAXBContext.newInstance((String)packageName, (ClassLoader)clazz.getClassLoader());
                contextsByPackageNames.put(packageName, context);
            }
            return context;
        }
    }

    public static Unmarshaller getUnmarshaller(Class<?> clazz) throws JAXBException {
        JAXBContext context = JAXBTools.getContext(clazz);
        return context.createUnmarshaller();
    }

    public static <T> T unmarshal(ILocator locator, Class<T> type) throws IOException {
        try (InputStream input = locator.getInputStream();){
            T t = JAXBTools.unmarshal(input, type);
            return t;
        }
    }

    public static <T> T unmarshal(InputStream input, Class<T> type) throws IOException {
        try {
            Unmarshaller unmarshaller = JAXBTools.getUnmarshaller(type);
            Object object = unmarshaller.unmarshal(input);
            return type.cast(object);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T> T unmarshalElement(ILocator locator, Class<T> declaredType) throws IOException {
        try (InputStream is = locator.getInputStream();){
            T t = JAXBTools.unmarshalElement(is, declaredType);
            return t;
        }
    }

    public static <T> T unmarshalElement(InputStream input, Class<T> declaredType) throws IOException {
        try {
            Unmarshaller unmarshaller = JAXBTools.getUnmarshaller(declaredType);
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(input);
            Object value = element.getValue();
            return declaredType.cast(value);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private JAXBTools() {
    }
}

