/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ipc;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.ipc.IIPCScope;
import de.intarsys.tools.ipc.IIPCStubFactory;
import de.intarsys.tools.ipc.IPCHandle;
import de.intarsys.tools.ipc.IPCScope;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public class IPCTools {
    private static final Attribute ATTR_IPC_SCOPE = new Attribute("ipcScope");

    public static <T> T createObject(Object value, IIPCStubFactory<T> factory) throws ObjectCreationException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return null;
            }
            throw new ObjectCreationException("invalid data type");
        }
        if (value instanceof IPCHandle) {
            IPCHandle handle = (IPCHandle)value;
            if (handle.isResolved()) {
                return (T)handle.getObject();
            }
            T object = factory.createObject(handle);
            ((IPCHandle)value).resolve(object);
            return object;
        }
        if (factory.getTargetClass().isInstance(value)) {
            return (T)value;
        }
        throw new ObjectCreationException("invalid data type");
    }

    public static void restore(IAttributeSupport as) {
        IIPCScope scope = null;
        if (as != null) {
            scope = (IIPCScope)as.getAttribute(ATTR_IPC_SCOPE);
        }
        IPCScope.set(scope);
    }

    public static void store(IAttributeSupport as) {
        if (as != null) {
            as.setAttribute(ATTR_IPC_SCOPE, IPCScope.lookup());
        }
    }

    private IPCTools() {
    }
}

