/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgsCryptoBase;
import de.intarsys.tools.functor.ArgsValidationException;
import de.intarsys.tools.functor.IArgs;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArgsValidator
extends ArgsCryptoBase {
    private List<Certificate> loadCertificates(IArgs contentArgs) throws ArgsValidationException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        IArgs certificatesArgs = ArgTools.getArgs(contentArgs, "signer.certificates", Args.create());
        for (int i = 0; i < certificatesArgs.size(); ++i) {
            IArgs certArgs = ArgTools.getArgs(certificatesArgs, String.valueOf(i), Args.create());
            byte[] certValue = ArgTools.getByteArray(certArgs, "value", null);
            if (certValue == null) {
                throw new ArgsValidationException("certificates." + i + ".value is missing");
            }
            String certType = ArgTools.getString(certArgs, "type", "X.509");
            try {
                Certificate cert = CertificateFactory.getInstance(certType).generateCertificate(new ByteArrayInputStream(certValue));
                certificates.add(cert);
                continue;
            }
            catch (CertificateException e) {
                throw new ArgsValidationException(e.getLocalizedMessage(), e);
            }
        }
        if (certificates.isEmpty()) {
            throw new ArgsValidationException("signature.content.signer.certificates is missing");
        }
        return certificates;
    }

    public List<Certificate> validate(IArgs args, IArgs signatureArgs) throws ArgsValidationException {
        String type = ArgTools.getString(signatureArgs, "type", "ArgDSig");
        String version = ArgTools.getString(signatureArgs, "version", "1.0");
        if ("ArgDSig".equals(type) && "1.0".equals(version)) {
            List<Certificate> certificates = this.validateSignature(signatureArgs);
            this.validateSignedArgsHash(args, signatureArgs);
            return certificates;
        }
        throw new ArgsValidationException("Unsupported signature type or version");
    }

    private List<Certificate> validateSignature(IArgs signatureArgs) throws ArgsValidationException {
        IArgs contentArgs = ArgTools.getArgs(signatureArgs, "content", Args.create());
        byte[] signatureValue = ArgTools.getByteArray(contentArgs, "value", null);
        if (signatureValue == null) {
            throw new ArgsValidationException("signature.content.value is missing");
        }
        IArgs signedArgs = ArgTools.getArgs(contentArgs, "signed", Args.create());
        String signatureAlgorithm = ArgTools.getString(signedArgs, "algorithm", "SHA256withRSA");
        List<Certificate> certificates = this.loadCertificates(contentArgs);
        try {
            Signature jcaSignature = Signature.getInstance(signatureAlgorithm);
            jcaSignature.initVerify(certificates.get(0));
            this.updateSignature(jcaSignature, signedArgs);
            if (!jcaSignature.verify(signatureValue)) {
                throw new ArgsValidationException("signature could not be verified");
            }
        }
        catch (GeneralSecurityException e) {
            throw new ArgsValidationException(e.getLocalizedMessage(), e);
        }
        return certificates;
    }

    private void validateSignedArgsHash(IArgs args, IArgs signatureArgs) throws ArgsValidationException {
        IArgs signedArgs = ArgTools.getArgs(signatureArgs, "content.signed", Args.create());
        byte[] hash = ArgTools.getByteArray(signedArgs, "hash.raw", null);
        if (hash == null) {
            hash = ArgTools.getByteArray(signedArgs, "hash.value", null);
        }
        if (hash == null) {
            throw new ArgsValidationException("signature.content.signed.hash.raw is missing");
        }
        List fields = ArgTools.getList(signedArgs, "select", DEFAULT_SELECT);
        String digestAlgorithm = ArgTools.getString(signedArgs, "hash.algorithm", "SHA-256");
        IArgs signedContent = this.createSignedContentArgs(args, fields);
        try {
            byte[] contentDigest = this.hash(digestAlgorithm, signedContent);
            if (!Arrays.equals(hash, contentDigest)) {
                throw new ArgsValidationException("args hash doesn't match the signed hash");
            }
        }
        catch (GeneralSecurityException e) {
            throw new ArgsValidationException(e.getLocalizedMessage(), e);
        }
    }
}

