/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgsPrinter;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.geometry.GeometryTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ArgTools {
    public static final IFunctor<String> TO_STRING = new IFunctor<String>(){

        @Override
        public String perform(IFunctorCall call) throws FunctorException {
            Args args = (Args)call.getReceiver();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (binding.getName() != null) {
                    sb.append(binding.getName());
                } else {
                    sb.append(i);
                }
                sb.append(" = ");
                sb.append(binding.getValue());
                sb.append("\n");
                ++i;
            }
            return sb.toString();
        }
    };
    public static final Object UNDEFINED = new Object();

    public static IArgs applyDeep(IArgs args, Function<IArgs.IBinding, Object> function) {
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (!binding.isDefined()) continue;
            Object value = binding.getValue();
            if (value instanceof IArgs) {
                ArgTools.applyDeep((IArgs)value, function);
                continue;
            }
            Object newValue = function.apply(binding);
            if (newValue == value || newValue == UNDEFINED) continue;
            binding.setValue(newValue);
        }
        return args;
    }

    protected static Object basicGet(IArgs args, int index, String name) {
        Object argsValue = name != null ? args.get(name) : args.get(index);
        return argsValue;
    }

    protected static Object basicGet(IArgs args, String name) {
        try {
            if (name.length() > 0 && Character.isDigit(name.charAt(0))) {
                int index = Integer.parseInt(name.trim());
                return args.get(index);
            }
            return args.get(name);
        }
        catch (NumberFormatException e) {
            return args.get(name);
        }
    }

    protected static Object basicGetOrUndefined(IArgs args, String name) {
        try {
            if (name.length() > 0 && Character.isDigit(name.charAt(0))) {
                int index = Integer.parseInt(name.trim());
                if (!args.isDefined(index)) {
                    return UNDEFINED;
                }
                return args.get(index);
            }
            if (!args.isDefined(name)) {
                return UNDEFINED;
            }
            return args.get(name);
        }
        catch (NumberFormatException e) {
            if (!args.isDefined(name)) {
                return UNDEFINED;
            }
            return args.get(name);
        }
    }

    protected static boolean basicIsDefined(IArgs args, int index, String name) {
        if (name != null) {
            return args.isDefined(name);
        }
        return args.isDefined(index);
    }

    protected static void basicPut(IArgs args, int index, String name, Object otherValue) {
        if (name == null) {
            args.put(index, otherValue);
        } else {
            args.put(name, otherValue);
        }
    }

    protected static <T> T convert(Object value, Class<T> clazz) throws ConversionException {
        return ConverterRegistry.get().convert(value, clazz);
    }

    protected static <T> T convert(Object value, Class<T> clazz, Object defaultValue) {
        try {
            return ArgTools.convertStrict(value, clazz, defaultValue);
        }
        catch (ConversionException conversionException) {
            return (T)defaultValue;
        }
    }

    protected static <T> T convertStrict(Object value, Class<T> clazz, Object defaultValue) throws ConversionException {
        T result = ArgTools.convert(value, clazz);
        if (result != null) {
            return result;
        }
        return (T)defaultValue;
    }

    public static IArgs createArgs() {
        return Args.create();
    }

    public static IArgs expandDeep(IArgs args, IStringEvaluator evaluator) {
        return ArgTools.applyDeep(args, binding -> StringEvaluatorTools.evaluate(evaluator, binding.getValue()));
    }

    public static IArgs expandDeep(IArgs args, String name, IStringEvaluator evaluator) {
        Object value = ArgTools.getPath(args, name);
        if (value instanceof IArgs) {
            ArgTools.expandDeep((IArgs)value, evaluator);
        } else if (value instanceof String) {
            try {
                Object newValue = evaluator.evaluate((String)value, Args.create());
                ArgTools.putPath(args, name, newValue);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return args;
    }

    public static IArgs flatten(IArgs args) {
        return ArgTools.flatten(args, null, Args.create());
    }

    public static IArgs flatten(IArgs args, String prefix, IArgs map) {
        int i = 0;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            Object value;
            IArgs.IBinding binding = it.next();
            if (!binding.isDefined()) continue;
            Object key = binding.getName() != null ? binding.getName() : "" + i;
            if (!StringTools.isEmpty(prefix)) {
                key = prefix + "." + (String)key;
            }
            if ((value = binding.getValue()) instanceof IArgs) {
                ArgTools.flatten((IArgs)value, (String)key, map);
            } else {
                map.put((String)key, value);
            }
            ++i;
        }
        return map;
    }

    public static <T> T get(IArgs args, String name, Class<T> clazz, Supplier<T> defaultSupplier) {
        if (args == null) {
            return defaultSupplier == null ? null : (T)defaultSupplier.get();
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultSupplier == null ? null : (T)defaultSupplier.get();
        }
        if (clazz.isInstance(optionValue)) {
            return (T)optionValue;
        }
        try {
            return ArgTools.convert(optionValue, clazz);
        }
        catch (ConversionException e) {
            return defaultSupplier == null ? null : (T)defaultSupplier.get();
        }
    }

    public static IArgs getArgs(IArgs args, String name, IArgs defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        return ArgTools.toArgs(optionValue);
    }

    public static boolean getBool(IArgs args, String name, boolean defaultValue) {
        try {
            return ArgTools.getBoolStrict(args, name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(IArgs args, String name, boolean defaultValue) {
        return ArgTools.getBool(args, name, defaultValue);
    }

    public static boolean getBoolStrict(IArgs args, String name, boolean defaultValue) {
        Object optionValue = ArgTools.getPath(args, name);
        return ArgTools.toBoolean(name, optionValue, defaultValue);
    }

    public static byte getByte(IArgs args, String name, byte defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return (byte)Integer.parseInt(((String)value).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, Byte.class, defaultValue);
    }

    public static byte[] getByteArray(IArgs args, String name, byte[] defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            try {
                return Converter.asBytes((String)value);
            }
            catch (ConverterException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        if (value instanceof ILocator) {
            try {
                return LocatorTools.getBytes((ILocator)value);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        if (value instanceof ILocatorSupport) {
            try {
                return LocatorTools.getBytes(((ILocatorSupport)value).getLocator());
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, byte[].class, defaultValue);
    }

    public static char getChar(IArgs args, String name, char defaultValue) {
        String valueString;
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String && (valueString = (String)value).length() > 0) {
            return valueString.charAt(0);
        }
        return ArgTools.convert(value, Character.class, Character.valueOf(defaultValue)).charValue();
    }

    public static char[] getCharArray(IArgs args, String name, char[] defaultValue) throws IllegalArgumentException {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof char[]) {
            return (char[])optionValue;
        }
        if (optionValue instanceof String) {
            return ((String)optionValue).toCharArray();
        }
        if (optionValue instanceof Secret) {
            try {
                return ((Secret)optionValue).getChars();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            return ArgTools.convert(optionValue, char[].class);
        }
        catch (ConversionException e) {
            return defaultValue;
        }
    }

    public static Class getClass(IArgs args, String name, Class defaultValue, ClassLoader classLoader) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Class) {
            return (Class)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                return ClassTools.createClass(optionString, Object.class, classLoader);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Class.class, defaultValue);
    }

    public static <T> Class<T> getClass(IArgs args, String name, Class<T> defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Class) {
            return (Class)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                return ClassTools.createClass(optionString, null, null);
            }
            catch (ObjectCreationException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Class.class, defaultValue);
    }

    public static Color getColor(IArgs args, String name, Color defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Color) {
            return (Color)optionValue;
        }
        return ArgTools.convert(optionValue, Color.class, defaultValue);
    }

    public static Date getDate(IArgs args, String name, Date defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Date) {
            return (Date)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS]'Z'");
                LocalDateTime localDateTime = LocalDateTime.parse(optionString.trim(), formatter);
                return Date.from(localDateTime.atZone(ZoneId.of("UTC")).toInstant());
            }
            catch (DateTimeParseException e) {
                try {
                    return DateFormat.getInstance().parse(optionString.trim());
                }
                catch (ParseException ex) {
                    return defaultValue;
                }
            }
        }
        return ArgTools.convert(optionValue, Date.class, defaultValue);
    }

    public static IDigest getDigest(IArgs args, String name) throws IOException {
        if (args == null) {
            return null;
        }
        Object optionValue = ArgTools.getPath(args, name);
        return DigestTools.createDigest(optionValue);
    }

    public static <T extends Enum<T>> T getEnum(IArgs args, Class<T> meta, String name, T defaultValue) {
        try {
            return ArgTools.getEnumStrict(args, meta, name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name) {
        return ArgTools.getEnumItem(args, meta, name, meta.getDefault());
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name, String defaultValue) {
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return meta.getItem(defaultValue);
        }
        if (optionValue instanceof EnumItem) {
            return (T)((EnumItem)optionValue);
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return (T)meta.getItem(optionString.trim(), defaultValue);
        }
        return (T)((EnumItem)ArgTools.convert(optionValue, meta.getEnumClazz(), meta.getItemOrDefault(defaultValue)));
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name, T defaultValue) {
        try {
            return ArgTools.getEnumItemStrict(args, meta, name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends EnumItem> T getEnumItemStrict(IArgs args, EnumMeta<T> meta, String name) {
        return ArgTools.getEnumItemStrict(args, meta, name, meta.getDefault());
    }

    public static <T extends EnumItem> T getEnumItemStrict(IArgs args, EnumMeta<T> meta, String name, T defaultValue) {
        Object optionValue = ArgTools.getPath(args, name);
        return ArgTools.toEnumItem(meta, name, optionValue, defaultValue);
    }

    public static <T extends Enum<T>> T getEnumStrict(IArgs args, Class<T> meta, String name, T defaultValue) {
        Object optionValue = ArgTools.getPath(args, name);
        return ArgTools.toEnum(meta, name, optionValue, defaultValue);
    }

    public static File getFile(IArgs args, String name, File defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File(((String)value).trim());
        }
        if (value instanceof FileLocator) {
            return ((FileLocator)value).getFile();
        }
        if (value instanceof ILocator) {
            return new File(((ILocator)value).getPath());
        }
        return ArgTools.convert(value, File.class, defaultValue);
    }

    public static float getFloat(IArgs args, String name, float defaultValue) {
        try {
            return ArgTools.getFloatStrict(args, name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getFloatStrict(IArgs args, String name, float defaultValue) {
        Object value = ArgTools.getPath(args, name);
        return ArgTools.toFloat(name, value, defaultValue);
    }

    public static int getInt(IArgs args, String name, int defaultValue) {
        try {
            return ArgTools.getIntStrict(args, name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getIntStrict(IArgs args, String name, int defaultValue) {
        Object value = ArgTools.getPath(args, name);
        return ArgTools.toInt(name, value, defaultValue);
    }

    public static List getList(IArgs args, String name, List defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof List) {
            return (List)optionValue;
        }
        if (optionValue instanceof Collection) {
            return new ArrayList((Collection)optionValue);
        }
        if (optionValue instanceof String) {
            return Converter.asList((String)optionValue);
        }
        if (optionValue instanceof IArgs) {
            return ArgTools.toList((IArgs)optionValue);
        }
        if (optionValue instanceof Object[]) {
            return Arrays.asList((Object[])optionValue);
        }
        return ArgTools.convert(optionValue, List.class, defaultValue);
    }

    public static ILocator getLocator(IArgs args, String name, ILocator defaultValue, ILocatorFactory factory) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        try {
            return LocatorTools.createLocator(optionValue, factory, defaultValue);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static List<ILocator> getLocators(IArgs args, String name, ILocatorFactory factory) {
        if (args == null) {
            return null;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return null;
        }
        if (optionValue instanceof ILocator[]) {
            return Arrays.asList((ILocator[])optionValue);
        }
        try {
            ArrayList<ILocator> locators = new ArrayList<ILocator>();
            if (optionValue instanceof Collection) {
                for (Object candidate : (Collection)optionValue) {
                    ILocator locator = LocatorTools.createLocator(candidate, factory, null);
                    if (locator == null) continue;
                    locators.add(locator);
                }
            } else if (optionValue instanceof Object[]) {
                Object[] values = (Object[])optionValue;
                for (int i = 0; i < values.length; ++i) {
                    ILocator locator = LocatorTools.createLocator(values[i], factory, null);
                    if (locator == null) continue;
                    locators.add(locator);
                }
            } else if (optionValue instanceof IArgs) {
                ILocator locator;
                IArgs.IBinding binding;
                Iterator<IArgs.IBinding> values = ((IArgs)optionValue).bindings();
                while (values.hasNext() && (binding = values.next()).getName() == null) {
                    ILocator locator2 = LocatorTools.createLocator(binding.getValue(), factory, null);
                    if (locator2 == null) continue;
                    locators.add(locator2);
                }
                if (locators.isEmpty() && (locator = LocatorTools.createLocator(optionValue, factory, null)) != null) {
                    locators.add(locator);
                }
            } else {
                ILocator locator = LocatorTools.createLocator(optionValue, factory, null);
                if (locator != null) {
                    locators.add(locator);
                }
            }
            return locators;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static long getLong(IArgs args, String name, long defaultValue) {
        try {
            return ArgTools.getLongStrict(args, name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLongStrict(IArgs args, String name, long defaultValue) {
        Object value = ArgTools.getPath(args, name);
        return ArgTools.toLong(name, value, defaultValue);
    }

    public static Map getMap(IArgs args, String name, Map defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Map) {
            return (Map)optionValue;
        }
        if (optionValue instanceof String) {
            return Converter.asMap((String)optionValue);
        }
        if (optionValue instanceof IArgs) {
            return ArgTools.toMap((IArgs)optionValue);
        }
        return ArgTools.convert(optionValue, Map.class, defaultValue);
    }

    public static Object getObject(IArgs args, String name, Object defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        return optionValue;
    }

    public static Object getPath(IArgs args, String path) {
        int position;
        if (args == null) {
            return null;
        }
        if (StringTools.isEmpty(path) || ".".equals(path)) {
            return args;
        }
        String[] segments = path.split("\\.");
        for (position = 0; position < segments.length - 1; ++position) {
            Object tempValue = ArgTools.basicGet(args, segments[position]);
            if ((args = ArgTools.toArgs(tempValue)) != null) continue;
            return null;
        }
        return ArgTools.basicGet(args, segments[position]);
    }

    public static Point2D getPoint(IArgs args, String name, Point2D defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Point2D) {
            return (Point2D)optionValue;
        }
        if (optionValue instanceof String) {
            try {
                return GeometryTools.parsePoint((String)optionValue);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Point2D.class, defaultValue);
    }

    public static Point2D getPointStrict(IArgs args, String name, String xName, String yName, Point2D defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return ArgTools.getPointStrictXY(args, xName, yName, defaultValue);
        }
        if (optionValue instanceof Point2D) {
            return (Point2D)optionValue;
        }
        if (optionValue instanceof String) {
            return GeometryTools.parsePoint((String)optionValue);
        }
        try {
            return ArgTools.convertStrict(optionValue, Point2D.class, defaultValue);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("'" + optionValue + "' not a valid point");
        }
    }

    protected static Point2D getPointStrictXY(IArgs args, String xName, String yName, Point2D defaultValue) {
        Object optionXValue = ArgTools.getPath(args, xName);
        Object optionYValue = ArgTools.getPath(args, yName);
        if (optionXValue == null && optionYValue == null) {
            return defaultValue;
        }
        if (optionXValue == null) {
            throw new IllegalArgumentException("'" + xName + "' missing");
        }
        if (optionYValue == null) {
            throw new IllegalArgumentException("'" + yName + "' missing");
        }
        try {
            return new Point2D.Float(ArgTools.toFloat(xName, optionXValue, 0.0f), ArgTools.toFloat(yName, optionYValue, 0.0f));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'" + optionXValue + "' or '" + optionYValue + "'not a valid point");
        }
    }

    public static Secret getSecretHide(IArgs args, String name, Secret defaultValue) throws IllegalArgumentException {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        Secret secret = CryptoTools.createSecret(optionValue);
        if (CryptoTools.isEmpty(secret)) {
            return defaultValue;
        }
        return secret;
    }

    public static Secret getSecretParse(IArgs args, String name, Secret defaultValue) throws IllegalArgumentException {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof char[]) {
            return Secret.parse(new String((char[])optionValue));
        }
        if (optionValue instanceof String) {
            return Secret.parse((String)optionValue);
        }
        if (optionValue instanceof Secret) {
            return (Secret)optionValue;
        }
        return defaultValue;
    }

    public static String getString(IArgs args, String name, String defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof String) {
            return (String)optionValue;
        }
        if (optionValue instanceof char[]) {
            return new String((char[])optionValue);
        }
        if (optionValue instanceof Secret) {
            try {
                return ((Secret)optionValue).getString();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return ArgTools.convert(optionValue, String.class, String.valueOf(optionValue));
    }

    public static URI getUriStrict(IArgs args, String name, URI defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        return ArgTools.toUri(name, value, defaultValue);
    }

    public static URL getUrlStrict(IArgs args, String name, URL defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        return ArgTools.toUrl(name, value, defaultValue);
    }

    public static <T> T getValue(IArgs args, String name, Class<T> clazz, Object defaultValue) {
        if (args == null) {
            return (T)defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        return ArgTools.convert(value, clazz, defaultValue);
    }

    public static boolean hasDefinedBindings(IArgs args) {
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (!binding.isDefined()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefined(IArgs args, String path) {
        Object tempValue;
        String name;
        int position;
        if (StringTools.isEmpty(path) || ".".equals(path)) {
            return true;
        }
        String[] segments = path.split("\\.");
        for (position = 0; position < segments.length - 1; ++position) {
            name = segments[position];
            tempValue = ArgTools.basicGetOrUndefined(args, name);
            if ((args = ArgTools.toArgs(tempValue)) != null) continue;
            return false;
        }
        name = segments[position];
        tempValue = ArgTools.basicGetOrUndefined(args, name);
        return tempValue != UNDEFINED;
    }

    public static boolean isNamed(IArgs args) {
        for (IArgs.IBinding binding : args) {
            if (binding.getName() == null) continue;
            return true;
        }
        return args.size() == 0;
    }

    public static String prefix(String prefix, String name) {
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        if (name == null) {
            return null;
        }
        return prefix + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static IArgs putAll(IArgs args, IArgs other) {
        if (other == null) {
            return args;
        }
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (binding.getName() == null) continue;
            args.put(binding.getName(), binding.getValue());
        }
        return args;
    }

    public static IArgs putAll(IArgs args, Map map) {
        if (map == null) {
            return args;
        }
        for (Map.Entry entry : map.entrySet()) {
            ArgTools.putPath(args, String.valueOf(entry.getKey()), entry.getValue());
        }
        return args;
    }

    public static IArgs putAllDeep(IArgs args, IArgs other) {
        if (other == null) {
            return args;
        }
        int index = -1;
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            ArgTools.putAllDeepBinding(args, ++index, binding);
        }
        return args;
    }

    public static IArgs putAllDeep(IArgs args, List list) {
        if (list == null) {
            return args;
        }
        int i = 0;
        for (Object listValue : list) {
            Object argsValue = args.get(i);
            if (argsValue instanceof IArgs) {
                if (listValue instanceof Map) {
                    ArgTools.putAllDeep((IArgs)argsValue, (Map)listValue);
                } else if (listValue instanceof List) {
                    ArgTools.putAllDeep((IArgs)argsValue, (List)listValue);
                } else {
                    args.put(i, listValue);
                }
            } else {
                args.put(i, ArgTools.toArgsValue(listValue));
            }
            ++i;
        }
        return args;
    }

    public static IArgs putAllDeep(IArgs args, Map map) {
        if (map == null) {
            return args;
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = String.valueOf(entry.getKey());
            Object mapValue = entry.getValue();
            Object argsValue = ArgTools.getPath(args, name);
            if (argsValue instanceof IArgs) {
                if (mapValue instanceof Map) {
                    ArgTools.putAllDeep((IArgs)argsValue, (Map)mapValue);
                    continue;
                }
                if (mapValue instanceof List) {
                    ArgTools.putAllDeep((IArgs)argsValue, (List)mapValue);
                    continue;
                }
                ArgTools.putPath(args, name, mapValue);
                continue;
            }
            ArgTools.putPath(args, name, ArgTools.toArgsValue(mapValue));
        }
        return args;
    }

    protected static void putAllDeepBinding(IArgs args, int index, IArgs.IBinding binding) {
        if (!binding.isDefined()) {
            return;
        }
        String name = binding.getName();
        Object otherValue = binding.getValue();
        if ("+".equals(name)) {
            args.add(otherValue);
        } else {
            Object argsValue = ArgTools.basicGet(args, index, name);
            if (argsValue instanceof IArgs) {
                if (otherValue instanceof IArgs) {
                    ArgTools.putAllDeep((IArgs)argsValue, (IArgs)otherValue);
                } else {
                    ArgTools.basicPut(args, index, name, otherValue);
                }
            } else {
                ArgTools.basicPut(args, index, name, otherValue);
            }
        }
    }

    public static IArgs putAllIfAbsent(IArgs args, IArgs other) {
        if (other == null) {
            return args;
        }
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (binding.getName() == null || args.isDefined(binding.getName())) continue;
            args.put(binding.getName(), binding.getValue());
        }
        return args;
    }

    public static IArgs putAllIfAbsent(IArgs args, Map map) {
        if (map == null) {
            return args;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            ArgTools.putPathIfAbsent(args, key, entry.getValue());
        }
        return args;
    }

    public static IArgs putAllIfAbsentDeep(IArgs args, IArgs other) {
        if (other == null) {
            return args;
        }
        int index = -1;
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            ++index;
            if (!binding.isDefined()) continue;
            String name = binding.getName();
            Object otherValue = binding.getValue();
            if (ArgTools.basicIsDefined(args, index, name)) {
                Object argsValue = ArgTools.basicGet(args, index, name);
                if (!(argsValue instanceof IArgs) || !(otherValue instanceof IArgs)) continue;
                ArgTools.putAllIfAbsentDeep((IArgs)argsValue, (IArgs)otherValue);
                continue;
            }
            ArgTools.basicPut(args, index, name, otherValue);
        }
        return args;
    }

    public static void putDefinition(IArgs args, String definition) {
        if (StringTools.isEmpty(definition)) {
            return;
        }
        StringReader r = new StringReader(definition);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                ArgTools.putPath(args, entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid definition '" + definition + "'");
        }
    }

    public static IArgs putMapped(IArgs args, IArgs other, String[] argsNames, String[] otherNames) {
        if (other == null) {
            return args;
        }
        for (int i = 0; i < otherNames.length; ++i) {
            ArgTools.putPath(args, argsNames[i], ArgTools.getPath(other, otherNames[i]));
        }
        return args;
    }

    public static IArgs putPath(IArgs args, String path, Object value) {
        int index;
        String name;
        int position;
        String[] segments = path.split("\\.");
        for (position = 0; position < segments.length - 1; ++position) {
            Object tempValue;
            block14: {
                name = segments[position];
                try {
                    if (name.length() > 0 && Character.isDigit(name.charAt(0))) {
                        index = Integer.parseInt(name.trim());
                        tempValue = args.get(index);
                        if (!(tempValue instanceof IArgs)) {
                            if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                                tempValue = Args.create();
                            }
                            args.put(index, tempValue);
                        }
                    } else {
                        tempValue = args.get(name);
                        if (!(tempValue instanceof IArgs)) {
                            if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                                tempValue = Args.create();
                            }
                            args.put(name, tempValue);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    tempValue = args.get(name);
                    if (tempValue instanceof IArgs) break block14;
                    if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                        tempValue = Args.create();
                    }
                    args.put(name, tempValue);
                }
            }
            args = (IArgs)tempValue;
        }
        name = segments[position];
        try {
            if (name.length() > 0 && Character.isDigit(name.charAt(0))) {
                index = Integer.parseInt(name.trim());
                args.put(index, value);
            } else {
                args.put(name, value);
            }
        }
        catch (NumberFormatException e) {
            args.put(name, value);
        }
        return args;
    }

    public static IArgs putPathIfAbsent(IArgs args, String path, Object value) {
        return ArgTools.putPathIfAbsent(args, path, () -> value);
    }

    public static IArgs putPathIfAbsent(IArgs args, String path, Supplier<?> supplier) {
        block10: {
            int index;
            String name;
            int position;
            String[] segments = path.split("\\.");
            for (position = 0; position < segments.length - 1; ++position) {
                Object tempValue;
                block9: {
                    name = segments[position];
                    try {
                        index = Integer.parseInt(name.trim());
                        tempValue = args.get(index);
                        if (!(tempValue instanceof IArgs)) {
                            if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                                tempValue = Args.create();
                            }
                            args.put(index, tempValue);
                        }
                    }
                    catch (NumberFormatException e) {
                        tempValue = args.get(name);
                        if (tempValue instanceof IArgs) break block9;
                        if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                            tempValue = Args.create();
                        }
                        args.put(name, tempValue);
                    }
                }
                args = (IArgs)tempValue;
            }
            name = segments[position];
            try {
                Object newValue;
                index = Integer.parseInt(name.trim());
                if (!args.isDefined(index) && (newValue = supplier.get()) != UNDEFINED) {
                    args.put(index, newValue);
                }
            }
            catch (NumberFormatException e) {
                Object newValue;
                if (args.isDefined(name) || (newValue = supplier.get()) == UNDEFINED) break block10;
                args.put(name, newValue);
            }
        }
        return args;
    }

    public static IArgs toArgs(Object value) {
        if (value == UNDEFINED) {
            return null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            return (IArgs)((Object)value);
        }
        if (value instanceof String) {
            value = Converter.asMap((String)((Object)value));
        }
        if (value instanceof Map) {
            return new Args(value);
        }
        if (value instanceof List) {
            return new Args((List)((Object)value));
        }
        return ArgTools.convert(value, IArgs.class, Args.create());
    }

    public static String toArgString(IArgs args) {
        Map<String, Object> map = ArgTools.toMapDeepFlat(args);
        StringWriter writer = new StringWriter();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            writer.append(entry.getKey());
            writer.append("=");
            if (entry.getValue() == null) {
                writer.append("");
            } else {
                String value;
                try {
                    value = ConverterRegistry.get().convert(entry.getValue(), String.class);
                }
                catch (ConversionException e) {
                    value = entry.getValue().toString();
                }
                writer.append(StringTools.quote(value));
            }
            writer.append(";");
        }
        return writer.toString();
    }

    public static Object toArgsValue(Object value) {
        if (value == UNDEFINED) {
            return null;
        }
        if (value instanceof Map) {
            return new Args((Map)value);
        }
        if (value instanceof List) {
            return new Args((List)value);
        }
        return value;
    }

    protected static boolean toBoolean(String name, Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String optionString = (String)value;
            try {
                return Converter.asBooleanStrict(optionString, defaultValue);
            }
            catch (ConverterException e) {
                throw new IllegalArgumentException("cannot convert '" + name + "' to boolean");
            }
        }
        try {
            return ArgTools.convertStrict(value, Boolean.class, defaultValue);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to boolean");
        }
    }

    protected static <T extends Enum<T>> T toEnum(Class<T> meta, String name, Object value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (meta.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return null;
            }
            String optionString = (String)value;
            return Enum.valueOf(meta, optionString);
        }
        try {
            return (T)((Enum)ArgTools.convertStrict(value, meta, defaultValue));
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to enum");
        }
    }

    protected static <T extends EnumItem> T toEnumItem(EnumMeta<T> meta, String name, Object value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof EnumItem) {
            return (T)((EnumItem)value);
        }
        if (value instanceof String) {
            String optionString = (String)value;
            return meta.getItemStrict(optionString.trim(), defaultValue);
        }
        try {
            return (T)((EnumItem)ArgTools.convertStrict(value, meta.getEnumClazz(), defaultValue));
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to enum");
        }
    }

    protected static float toFloat(String name, Object value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.indexOf("%") != -1) {
                try {
                    Number result = NumberFormat.getPercentInstance().parse(stringValue.trim());
                    return result.floatValue();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("cannot convert '" + name + "' to percent");
                }
            }
            try {
                return Float.parseFloat(stringValue.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("cannot convert '" + name + "' to float");
            }
        }
        try {
            return ArgTools.convertStrict(value, Float.class, Float.valueOf(defaultValue)).floatValue();
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to float");
        }
    }

    protected static int toInt(String name, Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt(((String)value).trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("cannot convert '" + name + "' to int");
            }
        }
        try {
            return ArgTools.convertStrict(value, Integer.class, defaultValue);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to int");
        }
    }

    public static Object toJavaDeep(IArgs args) {
        LinkedHashMap resultMap = new LinkedHashMap(args == null ? 0 : args.size());
        boolean named = false;
        if (args != null) {
            int index = -1;
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                named = named || binding.getName() != null;
                ArgTools.toJavaDeepBinding(resultMap, ++index, binding);
            }
        }
        if (named || resultMap.isEmpty()) {
            return resultMap;
        }
        return new ArrayList(resultMap.values());
    }

    protected static void toJavaDeepBinding(Map resultMap, int index, IArgs.IBinding binding) {
        Object key;
        if (!binding.isDefined()) {
            return;
        }
        Object value = binding.getValue();
        if (value instanceof IArgs) {
            value = ArgTools.toJavaDeep((IArgs)value);
        }
        if ((key = binding.getName()) == null) {
            key = "" + index;
        }
        resultMap.put(key, value);
    }

    public static List toList(IArgs args) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (args != null) {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                result.add(binding.getValue());
            }
        }
        return result;
    }

    protected static long toLong(String name, Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong(((String)value).trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("cannot convert '" + name + "' to long");
            }
        }
        try {
            return ArgTools.convertStrict(value, Long.class, defaultValue);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to long");
        }
    }

    public static Map toMap(IArgs args) {
        int i = 0;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (args != null) {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                Object value = binding.getValue();
                Object key = binding.getName() != null ? binding.getName() : "" + i;
                result.put(key, value);
                ++i;
            }
        }
        return result;
    }

    public static Map toMapDeep(IArgs args) {
        int i = 0;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (args != null) {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                Object value = binding.getValue();
                if (value instanceof IArgs) {
                    value = ArgTools.toMapDeep((IArgs)value);
                }
                Object key = binding.getName() != null ? binding.getName() : "" + i;
                result.put(key, value);
                ++i;
            }
        }
        return result;
    }

    public static Map<String, Object> toMapDeepFlat(IArgs args) {
        return ArgTools.toMapDeepFlat(args, null, new HashMap<String, Object>());
    }

    public static Map<String, Object> toMapDeepFlat(IArgs args, String prefix, Map<String, Object> map) {
        int i = 0;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            Object value;
            IArgs.IBinding binding = it.next();
            if (!binding.isDefined()) continue;
            Object key = binding.getName() != null ? binding.getName() : "" + i;
            if (!StringTools.isEmpty(prefix)) {
                key = prefix + "." + (String)key;
            }
            if ((value = binding.getValue()) instanceof IArgs) {
                ArgTools.toMapDeepFlat((IArgs)value, (String)key, map);
            } else {
                map.put((String)key, value);
            }
            ++i;
        }
        return map;
    }

    public static String toPrintString(IArgs args, String prefix) {
        return new ArgsPrinter().toPrintString(args, prefix);
    }

    public static String toPrintString(IArgs args, String prefix, String ... hide) {
        ArgsPrinter printer = new ArgsPrinter();
        for (String temp : hide) {
            printer.hide(temp);
        }
        return printer.toPrintString(args, prefix);
    }

    public static URI toUri(String name, Object value, URI defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof String) {
            try {
                return new URI(((String)value).trim());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("cannot convert '" + name + "' to URI", ex);
            }
        }
        try {
            return ArgTools.convertStrict(value, URI.class, defaultValue);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to URI");
        }
    }

    public static URL toUrl(String name, Object value, URL defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                return new URL(((String)value).trim());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("cannot convert '" + name + "' to URL", ex);
            }
        }
        try {
            return ArgTools.convertStrict(value, URL.class, defaultValue);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("cannot convert '" + name + "' to URL");
        }
    }

    public static void undefinePath(IArgs args, String path) {
        String name;
        if (StringTools.isEmpty(path)) {
            return;
        }
        int lastIndex = path.lastIndexOf(46);
        if (lastIndex > 0) {
            name = path.substring(lastIndex + 1);
            if ((args = ArgTools.toArgs(ArgTools.getPath(args, path.substring(0, lastIndex)))) == null) {
                return;
            }
        } else {
            name = path;
        }
        try {
            int index = Integer.parseInt(name.trim());
            args.undefine(index);
        }
        catch (NumberFormatException e) {
            args.undefine(name);
        }
    }

    public static void visitNamedBindings(String prefix, IArgs args, IBindingProcessor processor) {
        processor.visitArgs(prefix, args);
        int index = 0;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            Object value;
            IArgs.IBinding binding = it.next();
            String name = binding.getName();
            if (name == null) {
                name = String.valueOf(index);
            }
            if ((value = binding.getValue()) instanceof IArgs) {
                ArgTools.visitNamedBindings(StringTools.pathAppend(prefix, ".", name), (IArgs)value, processor);
            } else {
                processor.visitBinding(prefix, args, binding);
            }
            ++index;
        }
    }

    private ArgTools() {
    }

    public static interface IBindingProcessor {
        public Object visitArgs(String var1, IArgs var2);

        public Object visitBinding(String var1, IArgs var2, IArgs.IBinding var3);
    }
}

