/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MagicFileNumberTest {
    private static final Map TYPES = new HashMap();

    public static void addType(String fileSuffix, byte[] magicBytes) {
        if (fileSuffix == null || magicBytes == null || magicBytes.length == 0) {
            return;
        }
        Type type = new Type(fileSuffix, magicBytes);
        if (!TYPES.containsKey(type.getKey())) {
            TYPES.put(type.getKey(), type);
        }
    }

    protected static void addTypes() {
        MagicFileNumberTest.addType("bmp", new byte[]{66, 77});
        MagicFileNumberTest.addType("fits", new byte[]{83, 73, 77, 80, 76, 69});
        MagicFileNumberTest.addType("gif", new byte[]{71, 73, 70, 56});
        MagicFileNumberTest.addType("gks", new byte[]{71, 75, 83, 77});
        MagicFileNumberTest.addType("rgb", new byte[]{1, -38});
        MagicFileNumberTest.addType("itc", new byte[]{-15, 0, 64, -69});
        MagicFileNumberTest.addType("jpg", new byte[]{-1, -40, -1});
        MagicFileNumberTest.addType("nif", new byte[]{73, 73, 78, 49});
        MagicFileNumberTest.addType("pm", new byte[]{86, 73, 69, 87});
        MagicFileNumberTest.addType("png", new byte[]{-119, 80, 78, 71});
        MagicFileNumberTest.addType("ps", new byte[]{37, 33});
        MagicFileNumberTest.addType("ras", new byte[]{89, -90, 106, -107});
        MagicFileNumberTest.addType("tif", new byte[]{77, 77, 0, 42});
        MagicFileNumberTest.addType("tif", new byte[]{73, 73, 42, 0});
        MagicFileNumberTest.addType("xcf", new byte[]{103, 105, 109, 112, 32, 120, 99, 102, 32, 118});
        MagicFileNumberTest.addType("fig", new byte[]{35, 70, 73, 71});
        MagicFileNumberTest.addType("xpm", new byte[]{47, 42, 32, 88, 80, 77, 32, 42, 47});
        MagicFileNumberTest.addType("bz", new byte[]{66, 90});
        MagicFileNumberTest.addType("Z", new byte[]{31, -99});
        MagicFileNumberTest.addType("gz", new byte[]{31, -117});
        MagicFileNumberTest.addType("zip", new byte[]{80, 75, 3, 4});
        MagicFileNumberTest.addType("tar", new byte[]{117, 115, 116, 97, 114});
        MagicFileNumberTest.addType("exe", new byte[]{77, 90});
        MagicFileNumberTest.addType("unix elf", new byte[]{127, 69, 76, 70});
        MagicFileNumberTest.addType("pgp public ring", new byte[]{-103, 0});
        MagicFileNumberTest.addType("pgp security ring", new byte[]{-107, 1});
        MagicFileNumberTest.addType("pgp security ring", new byte[]{-107, 0});
        MagicFileNumberTest.addType("pgp encrypted data", new byte[]{-90, 0});
        MagicFileNumberTest.addType("pdf", "%PDF".getBytes(StandardCharsets.US_ASCII));
    }

    public static String guessFileSuffix(byte[] data) {
        String string;
        if (data == null) {
            return null;
        }
        RandomAccessByteArray ra = null;
        try {
            ra = new RandomAccessByteArray(data);
            string = MagicFileNumberTest.guessFileSuffix(ra);
        }
        catch (IOException e) {
            try {
                throw ExceptionTools.wrap(e);
            }
            catch (Throwable throwable) {
                StreamTools.close(ra);
                throw throwable;
            }
        }
        StreamTools.close(ra);
        return string;
    }

    public static String guessFileSuffix(IRandomAccess data) throws IOException {
        Iterator i = TYPES.entrySet().iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next().getValue();
            if (!type.matches(data)) continue;
            return type.getSuffix();
        }
        return null;
    }

    public static boolean isText(byte[] data) {
        boolean bl;
        RandomAccessByteArray ra = null;
        try {
            ra = new RandomAccessByteArray(data);
            bl = MagicFileNumberTest.isText(ra);
        }
        catch (IOException e) {
            try {
                throw ExceptionTools.wrap(e);
            }
            catch (Throwable throwable) {
                StreamTools.close(ra);
                throw throwable;
            }
        }
        StreamTools.close(ra);
        return bl;
    }

    public static boolean isText(IRandomAccess data) throws IOException {
        if (data == null) {
            return false;
        }
        data.reset();
        int c = data.read();
        for (int i = 0; c != -1 && i < 1024; ++i) {
            if (((c &= 0xFF) < 32 || c > 126) && c < 160) {
                switch (c) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            c = data.read();
        }
        return true;
    }

    private MagicFileNumberTest() {
    }

    static {
        MagicFileNumberTest.addTypes();
    }

    public static class Type {
        private String suffix;
        private byte[] magicBytes;

        public Type(String suffix, byte[] magic) {
            this.suffix = suffix;
            this.magicBytes = magic;
        }

        public String getKey() {
            return HexTools.bytesToHexString(this.magicBytes);
        }

        public byte[] getMagicBytes() {
            return this.magicBytes;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean matches(IRandomAccess data) throws IOException {
            data.reset();
            for (int i = 0; i < this.magicBytes.length; ++i) {
                if (this.magicBytes[i] == data.read()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

