/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.functor.IArgs;

public class ResolverMixin
implements IStringEvaluator {
    private final Object object;
    private IStringEvaluator expressionEvaluator;

    public ResolverMixin(Object object) {
        this.object = object;
    }

    protected IStringEvaluator createExpressionEvaluator() {
        MapResolver resolver = MapResolver.createStrict();
        resolver.setExceptionResolver(new IStringEvaluator(){

            @Override
            public Object evaluate(String expression, IArgs args) throws EvaluationException {
                return ResolverMixin.this.evaluateFallback(expression, args);
            }
        });
        this.createExpressionEvaluator(resolver);
        return resolver;
    }

    protected void createExpressionEvaluator(MapResolver resolver) {
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.getExpressionEvaluator().evaluate(expression, args);
    }

    protected Object evaluateFallback(String expression, IArgs args) throws EvaluationException {
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStringEvaluator getExpressionEvaluator() {
        ResolverMixin resolverMixin = this;
        synchronized (resolverMixin) {
            if (this.expressionEvaluator == null) {
                this.expressionEvaluator = this.createExpressionEvaluator();
            }
            return this.expressionEvaluator;
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void reset() {
        this.expressionEvaluator = null;
    }
}

