/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadTools {
    private static final Logger Log = LoggerFactory.getLogger((String)"de.intarsys.tools.concurrent.ThreadTools");

    public static Thread newThread(Runnable r, String name) {
        return ThreadTools.newThread(r, name, 5);
    }

    public static Thread newThread(Runnable r, String name, int priority) {
        Thread thread = new Thread(r, name);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof IllegalMonitorStateException) {
                    return;
                }
                Log.warn("uncaught exception in " + t, e);
            }
        });
        thread.setPriority(priority);
        return thread;
    }

    public static Thread newThreadDaemon(Runnable r, String name) {
        return ThreadTools.newThreadDaemon(r, name, 5);
    }

    public static Thread newThreadDaemon(Runnable r, String name, int priority) {
        Thread thread = new Thread(r, name);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof IllegalMonitorStateException) {
                    return;
                }
                Log.warn("uncaught exception in " + t, e);
            }
        });
        thread.setPriority(priority);
        return thread;
    }

    public static ThreadFactory newThreadFactory(String name) {
        return ThreadTools.newThreadFactory(name, 5);
    }

    public static ThreadFactory newThreadFactory(final String name, final int priority) {
        return new ThreadFactory(){
            private int counter;

            @Override
            public Thread newThread(Runnable r) {
                Object tempName = name;
                if (this.counter != 0) {
                    tempName = name + "+" + this.counter;
                }
                ++this.counter;
                return ThreadTools.newThread(r, (String)tempName, priority);
            }
        };
    }

    public static ThreadFactory newThreadFactoryDaemon(String name) {
        return ThreadTools.newThreadFactoryDaemon(name, 5);
    }

    public static ThreadFactory newThreadFactoryDaemon(final String name, final int priority) {
        return new ThreadFactory(){
            private int counter;

            @Override
            public Thread newThread(Runnable r) {
                Object tempName = name;
                if (this.counter != 0) {
                    tempName = name + "+" + this.counter;
                }
                ++this.counter;
                return ThreadTools.newThreadDaemon(r, (String)tempName, priority);
            }
        };
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ThreadTools() {
    }
}

