/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.ITaskCallbackSupport;
import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.TaskCallbackDispatcher;
import de.intarsys.tools.concurrent.TaskCancelled;
import de.intarsys.tools.concurrent.TaskExecutionException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.reflect.ObjectTools;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFuture<R>
implements Future<R>,
ITaskCallbackSupport<R> {
    protected static final Logger Log = LoggerFactory.getLogger(AbstractFuture.class);
    private static final String UNDEFINED = "undefined";
    private TaskCallbackDispatcher<R> callbacks;
    protected final Object lockTask = new Object();
    private Throwable exception;
    private R result;
    protected boolean cancelled;
    protected boolean computed;
    private final Object id;
    protected boolean active;
    private String label;

    protected AbstractFuture() {
        this.id = this.createId();
        this.label = UNDEFINED;
    }

    protected AbstractFuture(Object id, String label) {
        this.id = id;
        this.label = label;
    }

    protected AbstractFuture(String label) {
        this.id = this.createId();
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskCallback(ITaskCallback<R> callback) {
        boolean runImmediately = false;
        Object object = this.lockTask;
        synchronized (object) {
            if (this.callbacks == null) {
                this.callbacks = new TaskCallbackDispatcher();
            }
            this.callbacks.addTaskCallback(callback);
            runImmediately = this.computed || this.cancelled;
        }
        if (runImmediately) {
            try {
                if (this.isCancelled()) {
                    callback.failed(new TaskCancelled());
                } else if (this.exception != null) {
                    callback.failed(new TaskExecutionException(this.basicGetException()));
                } else {
                    callback.finished(this.basicGetResult());
                }
            }
            catch (Exception e) {
                Log.debug("{} callback execution failed", (Object)this.getLabel(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable basicGetException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R basicGetResult() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean interrupt) {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.cancelled) {
                return false;
            }
            if (this.computed) {
                Log.debug("{} can't cancel, already computed", (Object)this.getLabel());
                return false;
            }
            Log.debug("{} cancel {} task", (Object)this.getLabel(), (Object)(this.active ? "active" : "inactive"));
            if (interrupt) {
                this.checkInterrupt();
            }
            this.cancelled = true;
            this.lockTask.notifyAll();
        }
        this.handleCancel();
        return true;
    }

    protected void checkInterrupt() {
    }

    protected final void created() {
        if (this.label == UNDEFINED) {
            this.label = this.createLabel();
        }
        Log.trace("{} created", (Object)this.getLabel());
    }

    protected Object createId() {
        return ObjectTools.createId(this);
    }

    protected String createLabel() {
        return ObjectTools.createLabel(this, this.getId());
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long remainNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long lastNanos = System.nanoTime();
        Object object = this.lockTask;
        synchronized (object) {
            while (true) {
                long tempMillis;
                if (this.cancelled) {
                    throw ExceptionTools.cancellation();
                }
                if (this.computed) {
                    if (this.exception != null) {
                        throw new ExecutionException(this.exception);
                    }
                    return this.result;
                }
                if (timeout < 0L) break;
                if (timeout != 0L) {
                    long nowNanos = System.nanoTime();
                    remainNanos -= nowNanos - lastNanos;
                    lastNanos = nowNanos;
                }
                if ((tempMillis = TimeUnit.MILLISECONDS.convert(remainNanos, TimeUnit.NANOSECONDS)) <= 0L && timeout != 0L) {
                    throw new TimeoutException();
                }
                this.lockTask.wait(tempMillis);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    protected Object getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    protected String getStateString() {
        if (this.active) {
            return "active";
        }
        if (this.cancelled) {
            return "cancelled";
        }
        if (this.computed) {
            return "computed";
        }
        return "";
    }

    protected void handleCancel() {
        if (!this.active) {
            try {
                this.taskFailed();
            }
            finally {
                this.taskFinally();
            }
        }
    }

    protected final void handleException() {
        try {
            if (this.cancelled) {
                Log.debug("{} exception after cancel, undo", (Object)this.getLabel());
                this.undo();
            } else {
                Log.debug("{} exception ({})", (Object)this.getLabel(), (Object)ExceptionTools.getMessage(this.exception));
            }
            try {
                this.taskFailed();
            }
            finally {
                this.taskFinally();
            }
        }
        catch (Exception e) {
            Log.error("{} exception in exception handling", (Object)this.getLabel(), (Object)e);
        }
    }

    protected final void handleResult() {
        block9: {
            try {
                if (this.cancelled) {
                    Log.debug("{} computed after cancel, undo", (Object)this.getLabel());
                    this.undo();
                    try {
                        this.taskFailed();
                        break block9;
                    }
                    finally {
                        this.taskFinally();
                    }
                }
                Log.debug("{} computed", (Object)this.getLabel());
                try {
                    this.taskFinished();
                }
                finally {
                    this.taskFinally();
                }
            }
            catch (Exception e) {
                Log.error("{} exception in result handling", (Object)this.getLabel(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isComputed() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.computed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.computed || this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailed() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskCallback(ITaskCallback<R> callback) {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.callbacks == null) {
                return;
            }
            this.callbacks.removeTaskCallback(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lockTask;
        synchronized (object) {
            this.active = false;
            this.computed = false;
            this.exception = null;
            this.result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setException(Throwable e) {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.computed) {
                throw new InvalidRequestException(this + " already computed");
            }
            this.computed = true;
            this.active = false;
            this.exception = e;
            this.lockTask.notifyAll();
        }
        this.handleException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(R object) {
        Object object2 = this.lockTask;
        synchronized (object2) {
            if (this.computed) {
                throw new InvalidRequestException(this + " already computed");
            }
            this.computed = true;
            this.active = false;
            this.result = object;
            this.lockTask.notifyAll();
        }
        this.handleResult();
    }

    protected void taskFailed() {
        if (this.callbacks != null) {
            if (this.isCancelled()) {
                this.callbacks.failed(new TaskCancelled());
            } else {
                this.callbacks.failed(new TaskExecutionException(this.basicGetException()));
            }
        }
    }

    protected void taskFinally() {
    }

    protected void taskFinished() {
        if (this.callbacks != null) {
            this.callbacks.finished(this.basicGetResult());
        }
    }

    protected void taskStarted() throws Exception {
        if (this.callbacks instanceof ITaskListener) {
            this.callbacks.started();
        }
    }

    public String toString() {
        return this.getLabel();
    }

    protected void undo() {
    }
}

