/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.ExpireAfter;
import de.intarsys.tools.component.ExpireAnd;
import de.intarsys.tools.component.ExpireAt;
import de.intarsys.tools.component.ExpireNever;
import de.intarsys.tools.component.ExpireOr;
import de.intarsys.tools.component.ExpireTimeout;
import de.intarsys.tools.component.ExpireUsage;
import de.intarsys.tools.component.IExpirationSupport;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public abstract class ExpirationPredicate
implements IExpirationSupport,
IElementSerializable {
    protected static ExpirationPredicate basicCreate(IArgs args, String role, ExpirationPredicate defaultValue) throws ObjectCreationException {
        Object tempValue;
        String argName = ArgTools.prefix(role, "type");
        String tempType = ArgTools.getString(args, argName, null);
        ExpirationPredicate result = ExpirationPredicate.create(tempType, tempValue = ArgTools.getObject(args, argName = ArgTools.prefix(role, "value"), null), null);
        if (result == null) {
            result = ExpirationPredicate.createDeprecated(args);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static ExpirationPredicate create(IArgs args, ExpirationPredicate defaultValue) throws ObjectCreationException {
        return ExpirationPredicate.create(args, "expire", defaultValue);
    }

    public static ExpirationPredicate create(IArgs args, String role, ExpirationPredicate defaultValue) throws ObjectCreationException {
        if (StringTools.isEmpty(role)) {
            return null;
        }
        Object tempObject = ArgTools.getObject(args, role, null);
        if (tempObject != null) {
            if (tempObject instanceof ExpirationPredicate) {
                return (ExpirationPredicate)tempObject;
            }
            IArgs tempArgs = ArgTools.toArgs(tempObject);
            if (tempArgs != null) {
                return ExpirationPredicate.basicCreate(tempArgs, null, defaultValue);
            }
            return null;
        }
        return ExpirationPredicate.basicCreate(args, role, defaultValue);
    }

    public static ExpirationPredicate create(String type, Object value, ExpirationPredicate defaultValue) throws ObjectCreationException {
        if (StringTools.isEmpty(type)) {
            return defaultValue;
        }
        if ("after".equals(type)) {
            return new ExpireAfter(ExpirationPredicate.toLong(value, 0L));
        }
        if ("at".equals(type)) {
            return new ExpireAt(ExpirationPredicate.toLong(value, 0L));
        }
        if ("timeout".equals(type)) {
            return new ExpireTimeout(ExpirationPredicate.toLong(value, 0L));
        }
        if ("usage".equals(type)) {
            return new ExpireUsage((int)ExpirationPredicate.toLong(value, 0L));
        }
        if ("never".equals(type)) {
            return new ExpireNever();
        }
        if ("and".equals(type)) {
            IArgs args = ArgTools.toArgs(value);
            if (args != null) {
                ExpirationPredicate op1 = ExpirationPredicate.create(args, "op1", null);
                ExpirationPredicate op2 = ExpirationPredicate.create(args, "op2", null);
                return ExpirationPredicate.createAnd(op1, op2);
            }
            return null;
        }
        if ("or".equals(type)) {
            IArgs args = ArgTools.toArgs(value);
            if (args != null) {
                ExpirationPredicate op1 = ExpirationPredicate.create(args, "op1", null);
                ExpirationPredicate op2 = ExpirationPredicate.create(args, "op2", null);
                return ExpirationPredicate.createOr(op1, op2);
            }
            return null;
        }
        throw new ObjectCreationException("type '" + type + "' unknown");
    }

    public static ExpirationPredicate createAnd(ExpirationPredicate op1, ExpirationPredicate op2) {
        if (op1 == null) {
            return op2;
        }
        if (op2 == null) {
            return op1;
        }
        return new ExpireAnd(op1, op2);
    }

    protected static ExpirationPredicate createDeprecated(IArgs args) {
        Object tempValue;
        ExpirationPredicate result = null;
        int tempInt = ArgTools.getIntStrict(args, "expireTimeout", -1);
        if (tempInt != -1) {
            result = ExpirationPredicate.createOr(result, new ExpireTimeout(tempInt));
        }
        if ((tempInt = ArgTools.getIntStrict(args, "expireAfter", -1)) != -1) {
            result = ExpirationPredicate.createOr(result, new ExpireAfter(tempInt));
        }
        if ((tempInt = ArgTools.getIntStrict(args, "expireAt", -1)) != -1) {
            result = ExpirationPredicate.createOr(result, new ExpireAt(tempInt));
        }
        if ((tempInt = ArgTools.getIntStrict(args, "expireUsage", -1)) != -1) {
            result = ExpirationPredicate.createOr(result, new ExpireUsage(tempInt));
        }
        if ((tempValue = ArgTools.getObject(args, "expireNever", null)) != null) {
            result = ExpirationPredicate.createOr(result, new ExpireNever());
        }
        return result;
    }

    public static ExpirationPredicate createOr(ExpirationPredicate op1, ExpirationPredicate op2) {
        if (op1 == null) {
            return op2;
        }
        if (op2 == null) {
            return op1;
        }
        return new ExpireOr(op1, op2);
    }

    protected static long toLong(Object value, long defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong(((String)value).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public IExpirationSupport and(ExpirationPredicate op2) {
        return new ExpireAnd(this, op2);
    }

    public abstract ExpirationPredicate copy();

    public abstract String getType();

    public abstract long getValue();

    public IExpirationSupport or(ExpirationPredicate op2) {
        return new ExpireOr(this, op2);
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("type", this.getType());
        element.setAttributeValue("value", String.valueOf(this.getValue()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected abstract void toString(StringBuilder var1);
}

