/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class NestedIterator
implements Iterator {
    private Iterator innerIterator;
    private Object outerCurrent;
    private Iterator outerIterator;
    private boolean tryInner = true;

    public NestedIterator(Iterator i) {
        this.setOuterIterator(i);
    }

    public NestedIterator(List l) {
        this.setOuterIterator(l.iterator());
    }

    protected void createInnerIterator() {
        this.setInnerIterator(null);
        if (this.getOuterCurrent() != null) {
            if (this.getOuterCurrent() instanceof List) {
                this.setInnerIterator(new NestedIterator(((List)this.getOuterCurrent()).iterator()));
            }
            if (this.getOuterCurrent() instanceof Iterable) {
                this.setInnerIterator(new NestedIterator(((Iterable)this.getOuterCurrent()).iterator()));
            }
            if (this.getOuterCurrent() instanceof Iterator) {
                this.setInnerIterator(new NestedIterator((Iterator)this.getOuterCurrent()));
            }
        }
    }

    protected Iterator getInnerIterator() {
        return this.innerIterator;
    }

    protected Object getOuterCurrent() {
        return this.outerCurrent;
    }

    protected Iterator getOuterIterator() {
        return this.outerIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.isTryInner()) {
            if (!this.getOuterIterator().hasNext()) {
                return false;
            }
            this.setTryInner(false);
            this.setOuterCurrent(this.getOuterIterator().next());
            this.createInnerIterator();
        }
        if (this.getInnerIterator() == null) {
            return true;
        }
        if (this.getInnerIterator().hasNext()) {
            return true;
        }
        this.setTryInner(true);
        return this.hasNext();
    }

    private boolean isTryInner() {
        return this.tryInner;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more elements");
        }
        if (this.getInnerIterator() == null) {
            this.setTryInner(true);
            return this.getOuterCurrent();
        }
        return this.getInnerIterator().next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("iterator not modifiable");
    }

    private void setInnerIterator(Iterator newInnerIterator) {
        this.innerIterator = newInnerIterator;
    }

    private void setOuterCurrent(Object newOuterCurrent) {
        this.outerCurrent = newOuterCurrent;
    }

    private void setOuterIterator(Iterator newOuterIterator) {
        this.outerIterator = newOuterIterator;
    }

    private void setTryInner(boolean newTryInner) {
        this.tryInner = newTryInner;
    }
}

